import cgitb
import os
import socket
import subprocess
import time
import stat


cpaneluser = os.environ["USER"]
cpanelhome = os.environ["HOME"]
def close_cpanel_liveapisock():
    """We close the cpanel LiveAPI socket here as we dont need those"""
    cp_socket = os.environ["CPANEL_CONNECT_SOCKET"]
    sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    sock.connect(cp_socket)
    sock.sendall('<cpanelxml shutdown="1" />')
    sock.close()

cgitb.enable()



close_cpanel_liveapisock()

print('Content-Type: text/html')
print('')
socketpath = cpanelhome+'/tmp/redis.sock'
if os.path.exists(socketpath):
    mode = os.stat(socketpath).st_mode
    if stat.S_ISSOCK(mode):
        print("""<!DOCTYPE html>
        <html  lang="en">
         <head>
         <meta charset="utf-8" />
        <title>cPanel - Redis</title>
        <!-- Favicon-->
        <link rel="icon" type="image/x-icon" href="assets/favicon.ico" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

        <!-- Latest compiled and minified CSS -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.0/css/bootstrap.min.css">

        <!-- jQuery library -->
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
        <link rel="stylesheet" href="style.css">
        <!-- Latest compiled JavaScript -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>

        <script type="text/JavaScript" src="newjs.js"></script>
         </head>
         <body>

           <div class="container">
           <div class="row">
            <div class="col-sm-6">
                <img src="redisnew.png" alt="Redis_Image" class="left">
            </div>
            <div class="col-sm-6 mt7 center">
                <h1>Redis</h1>
                </div>
                <hr width="100%" height="10px" color="red" />
                <p class="para">The open source, in-memory data store used by millions of developers as a database, cache, streaming engine, and message broker.</p>
            </div>
            </div>


            <form method="POST" id="myform">

                <div class="container border">
                    <div class="row mt4 mb4">
                        <div class="col-sm-4 form-check" align="right">
                            <input class="form-check-input" type="radio" name="Option" value="ON" checked>
                            ON
                        </div>
                        <div class="col-sm-4 form-check" align="center">
                            <input class="form-check-input" type="radio" name="Option" value="OFF">
                            OFF
                        </div>
                        <div class="col-sm-2" align="left">
                            <button type="submit" id="btnId" class="btn btn-primary btn-sm submit-form">Submit</button>
                        </div>
                        <div id="pageloader" class="col-sm-2 hide" align="left">
                            <img src="loadingsmall2.gif" alt="processing..." />
                        </div>
                    </div>
                    <div class="row mt4 center mb4  ml4" > Please use the following socket path in your script to access Redis:&nbsp;<kbd><b>""")
        print(socketpath)
        print("""</b></kbd></div>
                </div>
            </form>
        </body>
        </html>
        """)
    else:
        print("ERROR: Stale Redis Socket")
else:
    print("""<!DOCTYPE html>
    <html  lang="en">
     <head>
     <meta charset="utf-8" />
    <title>cPanel - Redis</title>
    <!-- Favicon-->
    <link rel="icon" type="image/x-icon" href="assets/favicon.ico" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <!-- Latest compiled and minified CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.0/css/bootstrap.min.css">

    <!-- jQuery library -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <link rel="stylesheet" href="style.css">
    <!-- Latest compiled JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>

    <script type="text/JavaScript" src="newjs.js"></script>
     </head>
     <body>

       <div class="container">
        <div class="row">
         <div class="col-sm-6">
             <img src="redisnew.png" alt="Redis_Image" class="left">
         </div>
         <div class="col-sm-6 mt7 center">
             <h1>Redis</h1>
             </div>
            <hr width="100%" height="10px" color="red" />
            <p class="para">The open source, in-memory data store used by millions of developers as a database, cache, streaming engine, and message broker.</p>
            </div>
        </div>


        <form method="POST" id="myform">
            <div class="container border">
                <div class="row mt4 mb4">
                    <div class="col-sm-4 form-check" align="right">
                        <input class="form-check-input" type="radio" name="Option" value="ON" >
                         ON
                    </div>
                    <div class="col-sm-4 form-check" align="center">
                        <input class="form-check-input" type="radio" name="Option" value="OFF" checked>
                         OFF
                    </div>
                    <div class="col-sm-2" align="left">
                        <button type="submit" id="btnId" class="btn btn-primary btn-sm submit-form">Submit</button>
                    </div>
                    <div id="pageloader" class="col-sm-2 hide" align="left">
                        <img src="loadingsmall2.gif" alt="processing..." />
                    </div>
                </div>
            </div>
        </form>


    <div id="onsuccess" class="hide"></div>

     </body>
    </html>
    """)
