#!/usr/bin/env python3

import argparse
import json
import os
import subprocess

import yaml


__author__ = "Anoop P Alias"
__copyright__ = "Copyright Anoop P Alias"
__license__ = "GPL"
__email__ = "anoopalias01@gmail.com"


installation_path = "/opt/Autom8Redis"  # Absolute Installation Path

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Autom8Redis wrapper script for Ansible playbook run")
    parser.add_argument("CPUSER")
    parser.add_argument("CPHOME")
    parser.add_argument("STATUS")
    args = parser.parse_args()
    cpaneluser = args.CPUSER
    cpanelhome = args.CPHOME
    status = args.STATUS

    # get current hosting plan for the cPanel user
    if os.path.exists("/var/cpanel/users.cache/" + cpaneluser):
        with open("/var/cpanel/users.cache/" + cpaneluser, encoding='utf-8') as users_file:
            json_parsed_cpusersfile = json.load(users_file)
        myplan = json_parsed_cpusersfile.get('PLAN', 'default')
    else:
        # If cpanel users file is not present set plan to default
        myplan = 'default'
    # get maxmemory setting for the hosting PLAN
    if os.path.isfile(installation_path+"/plan_memory.yaml"):
        plan_memory_file = installation_path+"/plan_memory.yaml"
        plan_memory = open(plan_memory_file, 'r')
        plan_memory_yaml = yaml.safe_load(plan_memory)
        plan_memory.close()
        plan_memory_default = plan_memory_yaml.get('default', '32mb')
        plan_memory_user = plan_memory_yaml.get(myplan, plan_memory_default)
    else:
        plan_memory_user = '32mb'
    # Run Playbook with the data we have now
    extravars = 'CPANELUSER='+cpaneluser+' CPANELHOME='+cpanelhome+' MAXMEMORY='+plan_memory_user
    if status == "ON":
        subprocess.call('ansible-playbook -i /opt/Autom8Redis/redissetup/hosts /opt/Autom8Redis/redissetup/redis_init.yml --extra-vars "'+extravars+'"', shell=True)
    else:
        subprocess.call('ansible-playbook -i /opt/Autom8Redis/redissetup/hosts /opt/Autom8Redis/redissetup/redis_del.yml --extra-vars "'+extravars+'"', shell=True)
