<?php
/**
 * Industrial Technology Theme Customizer
 *
 * @package Industrial Technology
 */

function industrial_technology_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'Industrial_Technology_Customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'Industrial_Technology_Customize_partial_blogdescription',
			)
		);
	}

	/*
    * Theme Options Panel
    */
	$wp_customize->add_panel('industrial_technology_panel', array(
		'priority' => 25,
		'capability' => 'edit_theme_options',
		'title' => __('Industrial Theme Options', 'industrial-technology'),
	));

	/*
	* Customizer main header section
	*/

	$wp_customize->add_setting(
		'industrial_technology_site_title_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_site_title_text',
		array(
			'label'       => __('Enable Title', 'industrial-technology'),
			'description' => __('Enable or Disable Title from the site', 'industrial-technology'),
			'section'     => 'title_tagline',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting(
		'industrial_technology_site_tagline_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_site_tagline_text',
		array(
			'label'       => __('Enable Tagline', 'industrial-technology'),
			'description' => __('Enable or Disable Tagline from the site', 'industrial-technology'),
			'section'     => 'title_tagline',
			'type'        => 'checkbox',
		)
	);

		$wp_customize->add_setting(
		'industrial_technology_logo_width',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '150',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_logo_width',
		array(
			'label'       => __('Logo Width in PX', 'industrial-technology'),
			'section'     => 'title_tagline',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 100,
	             'max' => 300,
	             'step' => 1,
	         ),
		)
	);

	/*Additional Options*/
	$wp_customize->add_section('industrial_technology_additional_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Additional Options', 'industrial-technology'),
		'panel'       => 'industrial_technology_panel',
	));

	/*Main Slider Enable Option*/
	$wp_customize->add_setting(
		'industrial_technology_enable_sticky_header',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => false,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_enable_sticky_header',
		array(
			'label'       => __('Enable Sticky Header', 'industrial-technology'),
			'description' => __('Checked to enable sticky header', 'industrial-technology'),
			'section'     => 'industrial_technology_additional_section',
			'type'        => 'checkbox',
		)
	);

	/*Main Slider Enable Option*/
	$wp_customize->add_setting(
		'industrial_technology_enable_preloader',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_enable_preloader',
		array(
			'label'       => __('Enable Preloader', 'industrial-technology'),
			'description' => __('Checked to show preloader', 'industrial-technology'),
			'section'     => 'industrial_technology_additional_section',
			'type'        => 'checkbox',
		)
	);

	/*Breadcrumbs Enable Option*/
	$wp_customize->add_setting(
		'industrial_technology_enable_breadcrumbs',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_enable_breadcrumbs',
		array(
			'label'       => __('Enable Breadcrumbs', 'industrial-technology'),
			'description' => __('Checked to show Breadcrumbs', 'industrial-technology'),
			'section'     => 'industrial_technology_additional_section',
			'type'        => 'checkbox',
		)
	);

	/* WooCommerce custom settings */

	$wp_customize->add_section('woocommerce_custom_settings', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('WooCommerce Custom Settings', 'industrial-technology'),
		'panel'       => 'woocommerce',
	));

	$wp_customize->add_setting(
		'industrial_technology_per_columns',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_per_columns',
		array(
			'label'       => __('Product Per Single Row', 'industrial-technology'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 4,
	             'step' => 1,
	         ),
		)
	);

	$wp_customize->add_setting(
		'industrial_technology_product_per_page',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '6',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_product_per_page',
		array(
			'label'       => __('Product Per One Page', 'industrial-technology'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 12,
	             'step' => 1,
	         ),
		)
	);

	/*Related Products Enable Option*/
	$wp_customize->add_setting(
		'industrial_technology_enable_related_product',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_enable_related_product',
		array(
			'label'       => __('Enable Related Product', 'industrial-technology'),
			'description' => __('Checked to show Related Product', 'industrial-technology'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting(
		'custom_related_products_number',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'custom_related_products_number',
		array(
			'label'       => __('Related Product Count', 'industrial-technology'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 20,
	             'step' => 1,
	         ),
		)
	);

	$wp_customize->add_setting(
		'custom_related_products_number_per_row',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'custom_related_products_number_per_row',
		array(
			'label'       => __('Related Product Per Row', 'industrial-technology'),
			'section'     => 'woocommerce_custom_settings',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 4,
	             'step' => 1,
	         ),
		)
	);

	/*Archive Product layout*/
	$wp_customize->add_setting('industrial_technology_archive_product_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'industrial_technology_sanitize_choices'
	));
	$wp_customize->add_control('industrial_technology_archive_product_layout',array(
        'type' => 'select',
        'label' => esc_html__('Archive Product Layout','industrial-technology'),
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','industrial-technology'),
            'layout-2' => esc_html__('Sidebar On Left','industrial-technology'),
			'layout-3' => esc_html__('Full Width Layout','industrial-technology')
        ),
	) );

	/*Single Product layout*/
	$wp_customize->add_setting('industrial_technology_single_product_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'industrial_technology_sanitize_choices'
	));
	$wp_customize->add_control('industrial_technology_single_product_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Product Layout','industrial-technology'),
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','industrial-technology'),
            'layout-2' => esc_html__('Sidebar On Left','industrial-technology'),
			'layout-3' => esc_html__('Full Width Layout','industrial-technology')
        ),
	) );

	$wp_customize->add_setting('industrial_technology_woocommerce_product_sale',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
        'default'           => 'Right',
        'sanitize_callback' => 'industrial_technology_sanitize_choices'
    ));
    $wp_customize->add_control('industrial_technology_woocommerce_product_sale',array(
        'label'       => esc_html__( 'Woocommerce Product Sale Positions','industrial-technology' ),
        'type' => 'select',
        'section' => 'woocommerce_custom_settings',
        'choices' => array(
            'Right' => __('Right','industrial-technology'),
            'Left' => __('Left','industrial-technology'),
            'Center' => __('Center','industrial-technology')
        ),
    ) );


	/*Post layout*/
	$wp_customize->add_setting('industrial_technology_archive_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'industrial_technology_sanitize_choices'
	));
	$wp_customize->add_control('industrial_technology_archive_layout',array(
        'type' => 'select',
        'label' => esc_html__('Posts Layout','industrial-technology'),
        'section' => 'industrial_technology_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','industrial-technology'),
            'layout-2' => esc_html__('Sidebar On Left','industrial-technology'),
			'layout-3' => esc_html__('Full Width Layout','industrial-technology')
        ),
	) );

	/*single post layout*/
	$wp_customize->add_setting('industrial_technology_post_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'industrial_technology_sanitize_choices'
	));
	$wp_customize->add_control('industrial_technology_post_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Post Layout','industrial-technology'),
        'section' => 'industrial_technology_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','industrial-technology'),
            'layout-2' => esc_html__('Sidebar On Left','industrial-technology'),
			'layout-3' => esc_html__('Full Width Layout','industrial-technology')
        ),
	) );

	/*single page layout*/
	$wp_customize->add_setting('industrial_technology_page_layout',array(
        'default' => 'layout-1',
        'sanitize_callback' => 'industrial_technology_sanitize_choices'
	));
	$wp_customize->add_control('industrial_technology_page_layout',array(
        'type' => 'select',
        'label' => esc_html__('Single Page Layout','industrial-technology'),
        'section' => 'industrial_technology_additional_section',
        'choices' => array(
            'layout-1' => esc_html__('Sidebar On Right','industrial-technology'),
            'layout-2' => esc_html__('Sidebar On Left','industrial-technology'),
			'layout-3' => esc_html__('Full Width Layout','industrial-technology')
        ),
	) );

	
	/*Archive Post Options*/
	$wp_customize->add_section('industrial_technology_blog_post_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Blog Page Options', 'industrial-technology'),
		'panel'       => 'industrial_technology_panel',
	));

	$wp_customize->add_setting('industrial_technology_enable_blog_post_title',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_blog_post_title',array(
		'label'       => __('Enable Blog Post Title', 'industrial-technology'),
		'description' => __('Checked To Show Blog Post Title', 'industrial-technology'),
		'section'     => 'industrial_technology_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_blog_post_meta',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_blog_post_meta',array(
		'label'       => __('Enable Blog Post Meta', 'industrial-technology'),
		'description' => __('Checked To Show Blog Post Meta Feilds', 'industrial-technology'),
		'section'     => 'industrial_technology_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_blog_post_tags',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_blog_post_tags',array(
		'label'       => __('Enable Blog Post Tags', 'industrial-technology'),
		'description' => __('Checked To Show Blog Post Tags', 'industrial-technology'),
		'section'     => 'industrial_technology_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_blog_post_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_blog_post_image',array(
		'label'       => __('Enable Blog Post Image', 'industrial-technology'),
		'description' => __('Checked To Show Blog Post Image', 'industrial-technology'),
		'section'     => 'industrial_technology_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_blog_post_content',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_blog_post_content',array(
		'label'       => __('Enable Blog Post Content', 'industrial-technology'),
		'description' => __('Checked To Show Blog Post Content', 'industrial-technology'),
		'section'     => 'industrial_technology_blog_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_blog_post_button',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_blog_post_button',array(
		'label'       => __('Enable Blog Post Read More Button', 'industrial-technology'),
		'description' => __('Checked To Show Blog Post Read More Button', 'industrial-technology'),
		'section'     => 'industrial_technology_blog_post_section',
		'type'        => 'checkbox',
	));

	/*Blog post Content layout*/
	$wp_customize->add_setting('industrial_technology_blog_Post_content_layout',array(
        'default' => 'Left',
        'sanitize_callback' => 'industrial_technology_sanitize_choices'
	));
	$wp_customize->add_control('industrial_technology_blog_Post_content_layout',array(
        'type' => 'select',
        'label' => esc_html__('Blog Post Content Layout','industrial-technology'),
        'section' => 'industrial_technology_blog_post_section',
        'choices' => array(
            'Left' => esc_html__('Left','industrial-technology'),
            'Center' => esc_html__('Center','industrial-technology'),
            'Right' => esc_html__('Right','industrial-technology')
        ),
	) );

	/*Excerpt*/
    $wp_customize->add_setting(
		'industrial_technology_excerpt_limit',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '25',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_excerpt_limit',
		array(
			'label'       => __('Excerpt Limit', 'industrial-technology'),
			'section'     => 'industrial_technology_blog_post_section',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 2,
	             'max' => 50,
	             'step' => 2,
	         ),
		)
	);

	/*Archive Button Text*/
	$wp_customize->add_setting(
		'industrial_technology_read_more_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 'Continue Reading....',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_read_more_text',
		array(
			'label'       => __('Edit Button Text ', 'industrial-technology'),
			'section'     => 'industrial_technology_blog_post_section',
			'type'        => 'text',
		)
	);

	/*Single Post Options*/
	$wp_customize->add_section('industrial_technology_single_post_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Single Post Options', 'industrial-technology'),
		'panel'       => 'industrial_technology_panel',
	));

	$wp_customize->add_setting('industrial_technology_enable_single_blog_post_title',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_single_blog_post_title',array(
		'label'       => __('Enable Single Post Title', 'industrial-technology'),
		'description' => __('Checked To Show Single Blog Post Title', 'industrial-technology'),
		'section'     => 'industrial_technology_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_single_blog_post_meta',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_single_blog_post_meta',array(
		'label'       => __('Enable Single Post Meta', 'industrial-technology'),
		'description' => __('Checked To Show Single Blog Post Meta Feilds', 'industrial-technology'),
		'section'     => 'industrial_technology_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_single_blog_post_tags',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_single_blog_post_tags',array(
		'label'       => __('Enable Single Post Tags', 'industrial-technology'),
		'description' => __('Checked To Show Single Blog Post Tags', 'industrial-technology'),
		'section'     => 'industrial_technology_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_single_post_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_single_post_image',array(
		'label'       => __('Enable Single Post Image', 'industrial-technology'),
		'description' => __('Checked To Show Single Post Image', 'industrial-technology'),
		'section'     => 'industrial_technology_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting('industrial_technology_enable_single_blog_post_content',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 1,
		'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
	));
	$wp_customize->add_control('industrial_technology_enable_single_blog_post_content',array(
		'label'       => __('Enable Single Post Content', 'industrial-technology'),
		'description' => __('Checked To Show Single Blog Post Content', 'industrial-technology'),
		'section'     => 'industrial_technology_single_post_section',
		'type'        => 'checkbox',
	));

	$wp_customize->add_setting(
		'industrial_technology_enable_related_post',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_enable_related_post',
		array(
			'label'       => __('Enable Related Post', 'industrial-technology'),
			'description' => __('Checked to show Related Post', 'industrial-technology'),
			'section'     => 'industrial_technology_single_post_section',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting(
		'industrial_technology_related_post_text',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 'Related Post',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_related_post_text',
		array(
			'label'       => __('Edit Related Post Text ', 'industrial-technology'),
			'section'     => 'industrial_technology_single_post_section',
			'type'        => 'text',
		)
	);	

	$wp_customize->add_setting(
		'industrial_technology_related_post_count',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '3',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_related_post_count',
		array(
			'label'       => __('Related Post Count', 'industrial-technology'),
			'section'     => 'industrial_technology_single_post_section',
			'type'        => 'number',
			'input_attrs' => array(
	            'min' => 1,
	             'max' => 9,
	             'step' => 1,
	         ),
		)
	);

	/*
	* Customizer Global COlor
	*/

	/*Global Color Options*/
	$wp_customize->add_section('industrial_technology_global_color_section', array(
		'priority'       => 1,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Global Color Options', 'industrial-technology'),
		'panel'       => 'industrial_technology_panel',
	));

	$wp_customize->add_setting( 'industrial_technology_primary_color',
		array(
		'default'           => '#FF5E14',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
		)
	);
	$wp_customize->add_control( 
		new WP_Customize_Color_Control( 
		$wp_customize, 
		'industrial_technology_primary_color',
		array(
			'label'      => esc_html__( 'Primary Color', 'industrial-technology' ),
			'section'    => 'industrial_technology_global_color_section',
			'settings'   => 'industrial_technology_primary_color',
		) ) 
	);
	
	/*Main Header Options*/
	$wp_customize->add_section('industrial_technology_header_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Main Header Options', 'industrial-technology'),
		'panel'       => 'industrial_technology_panel',
	));

	/*
	* Customizer top header section
	*/

	/*
	* Customizer main header section
	*/

	/*Main Header Options*/
	$wp_customize->add_section('industrial_technology_header_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Main Header Options', 'industrial-technology'),
		'panel'       => 'industrial_technology_panel',
	));

	$wp_customize->add_setting(
		'industrial_technology_main_topbar',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_main_topbar',
		array(
			'label'       => __('Enable Topbar', 'industrial-technology'),
			'description' => __('Checked to show the Topbar', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting(
		'industrial_technology_header_search',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_header_search',
		array(
			'label'       => __('Enable Disable Search', 'industrial-technology'),
			'description' => __('Enable or Disable header Search', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'checkbox',
		)
	);

	/*Main Header Phone Text*/
	$wp_customize->add_setting(
		'industrial_technology_header_info_phone',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'industrial_technology_header_info_phone',
		array(
			'label'       => __('Edit Phone Number ', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'text',
		)
	);

	/*Main Header email Text*/
	$wp_customize->add_setting(
		'industrial_technology_header_info_email',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'industrial_technology_header_info_email',
		array(
			'label'       => __('Edit Email Address ', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'text',
		)
	);

	/*Main Header Address Text*/
	$wp_customize->add_setting(
		'industrial_technology_header_info_time',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_header_info_time',
		array(
			'label'       => __('Edit Timing ', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'text',
		)
	);

	/*Facebook Link*/
	$wp_customize->add_setting(
		'industrial_technology_facebook_link_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_facebook_link_option',
		array(
			'label'       => __('Edit Facebook Link', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'url',
		)
	);

	/*Twitter Link*/
	$wp_customize->add_setting(
		'industrial_technology_twitter_link_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_twitter_link_option',
		array(
			'label'       => __('Edit Twitter Link', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'url',
		)
	);


	$wp_customize->add_setting(
		'industrial_technology_youtube_link_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control(
		'industrial_technology_youtube_link_option',
		array(
			'label'       => __('Edit Youtube Link', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'url',
		)
	);

	$wp_customize->add_setting(
		'industrial_technology_linked_link_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control(
		'industrial_technology_linked_link_option',
		array(
			'label'       => __('Edit Linkedin Link', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'url',
		)
	);

	/*Instagram Link*/
	$wp_customize->add_setting(
		'industrial_technology_instagram_link_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_instagram_link_option',
		array(
			'label'       => __('Edit Instagram Link', 'industrial-technology'),
			'section'     => 'industrial_technology_header_section',
			'type'        => 'url',
		)
	);

	/*
	* Customizer main slider section
	*/
	/*Main Slider Options*/
	$wp_customize->add_section('industrial_technology_slider_section', array(
		'priority'       => 5,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Main Slider Options', 'industrial-technology'),
		'panel'       => 'industrial_technology_panel',
	));

	/*Main Slider Enable Option*/
	$wp_customize->add_setting(
		'industrial_technology_enable_slider',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 0,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_enable_slider',
		array(
			'label'       => __('Enable Main Slider', 'industrial-technology'),
			'description' => __('Checked to show the main slider', 'industrial-technology'),
			'section'     => 'industrial_technology_slider_section',
			'type'        => 'checkbox',
		)
	);

	for ($industrial_technology_i=1; $industrial_technology_i <= 3; $industrial_technology_i++) { 

		/*Main Slider Image*/
		$wp_customize->add_setting(
			'industrial_technology_slider_image'.$industrial_technology_i,
			array(
				'capability'    => 'edit_theme_options',
		        'default'       => '',
		        'transport'     => 'postMessage',
		        'sanitize_callback' => 'esc_url_raw',
	    	)
	    );

		$wp_customize->add_control( 
			new WP_Customize_Image_Control( $wp_customize, 
				'industrial_technology_slider_image'.$industrial_technology_i, 
				array(
			        'label' => __('Edit Slider Image ', 'industrial-technology') .$industrial_technology_i,
			        'description' => __('Edit the slider image.', 'industrial-technology'),
			        'section' => 'industrial_technology_slider_section',
				)
			)
		);

		/*Main Slider Heading*/
		$wp_customize->add_setting(
			'industrial_technology_slider_top_text'.$industrial_technology_i,
			array(
				'capability'        => 'edit_theme_options',
				'transport'         => 'refresh',
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'industrial_technology_slider_top_text'.$industrial_technology_i,
			array(
				'label'       => __('Edit Slider Top Text ', 'industrial-technology') .$industrial_technology_i,
				'description' => __('Edit the slider Top text.', 'industrial-technology'),
				'section'     => 'industrial_technology_slider_section',
				'type'        => 'text',
			)
		);

		/*Main Slider Heading*/
		$wp_customize->add_setting(
			'industrial_technology_slider_heading'.$industrial_technology_i,
			array(
				'capability'        => 'edit_theme_options',
				'transport'         => 'refresh',
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'industrial_technology_slider_heading'.$industrial_technology_i,
			array(
				'label'       => __('Edit Heading Text ', 'industrial-technology') .$industrial_technology_i,
				'description' => __('Edit the slider heading text.', 'industrial-technology'),
				'section'     => 'industrial_technology_slider_section',
				'type'        => 'text',
			)
		);

		/*Main Slider Content*/
		$wp_customize->add_setting(
			'industrial_technology_slider_text'.$industrial_technology_i,
			array(
				'capability'        => 'edit_theme_options',
				'transport'         => 'refresh',
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'industrial_technology_slider_text'.$industrial_technology_i,
			array(
				'label'       => __('Edit Content Text ', 'industrial-technology') .$industrial_technology_i,
				'description' => __('Edit the slider content text.', 'industrial-technology'),
				'section'     => 'industrial_technology_slider_section',
				'type'        => 'text',
			)
		);

		/*Main Slider Button1 Text*/
		$wp_customize->add_setting(
			'industrial_technology_slider_button1_text'.$industrial_technology_i,
			array(
				'capability'        => 'edit_theme_options',
				'transport'         => 'refresh',
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);
		$wp_customize->add_control(
			'industrial_technology_slider_button1_text'.$industrial_technology_i,
			array(
				'label'       => __('Edit Button #1 Text ', 'industrial-technology') .$industrial_technology_i,
				'description' => __('Edit the slider button text.', 'industrial-technology'),
				'section'     => 'industrial_technology_slider_section',
				'type'        => 'text',
			)
		);

		/*Main Slider Button1 URL*/
		$wp_customize->add_setting(
			'industrial_technology_slider_button1_link'.$industrial_technology_i,
			array(
				'capability'        => 'edit_theme_options',
				'transport'         => 'refresh',
				'default'           => '',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'industrial_technology_slider_button1_link'.$industrial_technology_i,
			array(
				'label'       => __('Edit Button #1 URL ', 'industrial-technology') .$industrial_technology_i,
				'description' => __('Edit the slider button url.', 'industrial-technology'),
				'section'     => 'industrial_technology_slider_section',
				'type'        => 'url',
			)
		);
	}

	// Existing Section and Basic Settings
    $wp_customize->add_section('industrial_technology_main_about_section', array(
        'priority'       => 5,
        'capability'     => 'edit_theme_options',
        'title'          => __('Main About Options', 'industrial-technology'),
        'panel'          => 'industrial_technology_panel',
    ));

    // Enable Option
    $wp_customize->add_setting('industrial_technology_about_sec', array(
        'capability'        => 'edit_theme_options',
        'default'           => 0,
        'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
    ));
    $wp_customize->add_control('industrial_technology_about_sec', array(
        'label'       => __('Enable About Section', 'industrial-technology'),
        'section'     => 'industrial_technology_main_about_section',
        'type'        => 'checkbox',
    ));

    $wp_customize->add_setting('industrial_technology_about_bg',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'industrial_technology_about_bg',array(
	    'label' => __('Select About Image','industrial-technology'),
	     'section' => 'industrial_technology_main_about_section'
	)));

	// YouTube URL
	$wp_customize->add_setting(
	    'industrial_technology_youtube_url',
	    array(
	        'default'           => '#',
	        'sanitize_callback' => 'esc_url_raw',
	    )
	);

	$wp_customize->add_control(
	    'industrial_technology_youtube_url',
	    array(
	        'type'    => 'url',
	        'label'   => __('YouTube URL', 'industrial-technology'),
	        'section' => 'industrial_technology_main_about_section',
	    )
	);

    $wp_customize->add_setting('industrial_technology_total_no_happy_customer',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('industrial_technology_total_no_happy_customer',array(
		'label'	=> __('Add Total Number Of Happy Customer','industrial-technology'),
		'section'	=> 'industrial_technology_main_about_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('industrial_technology_total_no_yr_experience',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('industrial_technology_total_no_yr_experience',array(
		'label'	=> __('Add Total Experience','industrial-technology'),
		'section'	=> 'industrial_technology_main_about_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('industrial_technology_total_no_project_done',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('industrial_technology_total_no_project_done',array(
		'label'	=> __('Add Total Number Of Projects Done','industrial-technology'),
		'section'	=> 'industrial_technology_main_about_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('industrial_technology_total_no_support',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('industrial_technology_total_no_support',array(
		'label'	=> __('Add Total Supports','industrial-technology'),
		'section'	=> 'industrial_technology_main_about_section',
		'type'		=> 'text'
	));

	/*
	* Customizer Footer Section
	*/
	/*Footer Options*/
	$wp_customize->add_section('industrial_technology_footer_section', array(
		'priority'       => 8,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Footer Options', 'industrial-technology'),
		'panel'       => 'industrial_technology_panel',
	));

	/*Footer Enable Option*/
	$wp_customize->add_setting(
		'industrial_technology_enable_footer',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'industrial_technology_enable_footer',
		array(
			'label'       => __('Enable Footer', 'industrial-technology'),
			'description' => __('Checked to show Footer', 'industrial-technology'),
			'section'     => 'industrial_technology_footer_section',
			'type'        => 'checkbox',
		)
	);

	/*Footer bg image Option*/
	$wp_customize->add_setting('industrial_technology_footer_bg_image',array(
		'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'industrial_technology_footer_bg_image',array(
        'label' => __('Footer Background Image','industrial-technology'),
        'section' => 'industrial_technology_footer_section',
        'priority' => 1,
    )));


	/*Footer Social Menu Option*/
	$wp_customize->add_setting(
		'industrial_technology_footer_social_menu',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_footer_social_menu',
		array(
			'label'       => __('Enable Footer Social Menu', 'industrial-technology'),
			'description' => __('Checked to show the footer social menu. Go to Dashboard >> Appearance >> Menus >> Create New Menu >> Add Custom Link >> Add Social Menu >> Checked Social Menu >> Save Menu.', 'industrial-technology'),
			'section'     => 'industrial_technology_footer_section',
			'type'        => 'checkbox',
		)
	);	

	/*Go To Top Option*/
	$wp_customize->add_setting(
		'industrial_technology_enable_go_to_top_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => 1,
			'sanitize_callback' => 'industrial_technology_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_enable_go_to_top_option',
		array(
			'label'       => __('Enable Go To Top', 'industrial-technology'),
			'description' => __('Checked to enable Go To Top option.', 'industrial-technology'),
			'section'     => 'industrial_technology_footer_section',
			'type'        => 'checkbox',
		)
	);

	$wp_customize->add_setting('industrial_technology_go_to_top_position',array(
        'capability'        => 'edit_theme_options',
		'transport'         => 'refresh',
		'default'           => 'Right',
        'sanitize_callback' => 'industrial_technology_sanitize_choices'
    ));
    $wp_customize->add_control('industrial_technology_go_to_top_position',array(
        'type' => 'select',
        'section' => 'industrial_technology_footer_section',
        'label' => esc_html__('Go To Top Positions','industrial-technology'),
        'choices' => array(
            'Right' => __('Right','industrial-technology'),
            'Left' => __('Left','industrial-technology'),
            'Center' => __('Center','industrial-technology')
        ),
    ) );

	/*Footer Copyright Text Enable*/
	$wp_customize->add_setting(
		'industrial_technology_copyright_option',
		array(
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'industrial_technology_copyright_option',
		array(
			'label'       => __('Edit Copyright Text', 'industrial-technology'),
			'description' => __('Edit the Footer Copyright Section.', 'industrial-technology'),
			'section'     => 'industrial_technology_footer_section',
			'type'        => 'text',
		)
	);
}
add_action( 'customize_register', 'industrial_technology_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function Industrial_Technology_Customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function Industrial_Technology_Customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function Industrial_Technology_Customize_preview_js() {
	wp_enqueue_script( 'industrial-technology-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), INDUSTRIAL_TECHNOLOGY_VERSION, true );
}
add_action( 'customize_preview_init', 'Industrial_Technology_Customize_preview_js' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Industrial_Technology_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $industrial_technology_instance = null;

		if ( is_null( $industrial_technology_instance ) ) {
			$industrial_technology_instance = new self;
			$industrial_technology_instance->setup_actions();
		}

		return $industrial_technology_instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $industrial_technology_manager
	 * @return void
	*/
	public function sections( $industrial_technology_manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/revolution/inc/section-pro.php' );

		// Register custom section types.
		$industrial_technology_manager->register_section_type( 'Industrial_Technology_Customize_Section_Pro' );

		// Register sections.
		$industrial_technology_manager->add_section( new Industrial_Technology_Customize_Section_Pro( $industrial_technology_manager,'industrial_technology_go_pro', array(
			'priority'   => 1,
			'title'    => esc_html__( 'Industrial Technology Pro', 'industrial-technology' ),
			'pro_text' => esc_html__( 'Buy Pro', 'industrial-technology' ),
			'pro_url'    => esc_url( INDUSTRIAL_TECHNOLOGY_BUY_NOW ),
		) )	);

		// Register sections.
		$industrial_technology_manager->add_section( new Industrial_Technology_Customize_Section_Pro( $industrial_technology_manager,'industrial_technology_lite_documentation', array(
			'priority'   => 1,
			'title'    => esc_html__( 'Lite Documentation', 'industrial-technology' ),
			'pro_text' => esc_html__( 'Instruction', 'industrial-technology' ),
			'pro_url'    => esc_url( INDUSTRIAL_TECHNOLOGY_LITE_DOC ),
		) )	);

		$industrial_technology_manager->add_section( new Industrial_Technology_Customize_Section_Pro( $industrial_technology_manager, 'industrial_technology_live_demo', array(
		    'priority'   => 1,
		    'title'      => esc_html__( 'Pro Theme Demo', 'industrial-technology' ),
		    'pro_text'   => esc_html__( 'Live Preview', 'industrial-technology' ),
		    'pro_url'    => esc_url( INDUSTRIAL_TECHNOLOGY_LIVE_DEMO ),
		) ) );	
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'industrial-technology-customize-controls', trailingslashit( get_template_directory_uri() ) . '/revolution/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'industrial-technology-customize-controls', trailingslashit( get_template_directory_uri() ) . '/revolution/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Industrial_Technology_Customize::get_instance();