<?php
/**
 * @package Demo Import
 * @since 1.0.0
 */

class ThemeWhizzie {

	protected $version = '1.1.0';

	/** @var string Current theme name, used as namespace in actions. */
	protected $theme_name = '';
	protected $theme_title = '';

	/** @var string Demo Import page slug and title. */
	protected $page_slug = '';
	protected $page_title = '';

	/** @var array Demo Import steps set by user. */
	protected $config_steps = array();
	public $parent_slug;
	/**
	 * Constructor
	 *
	 * @param $industrial_technology_config	Our config parameters
	*/
	public function __construct( $industrial_technology_config ) {
		$this->set_vars( $industrial_technology_config );
		$this->init();
	}

	/**
	 * Set some settings
	 * @since 1.0.0
	 * @param $industrial_technology_config	Our config parameters
	*/
	public function set_vars( $industrial_technology_config ) {
		if( isset( $industrial_technology_config['page_slug'] ) ) {
			$this->page_slug = esc_attr( $industrial_technology_config['page_slug'] );
		}
		if( isset( $industrial_technology_config['page_title'] ) ) {
			$this->page_title = esc_attr( $industrial_technology_config['page_title'] );
		}
		if( isset( $industrial_technology_config['steps'] ) ) {
			$this->config_steps = $industrial_technology_config['steps'];
		}

		$current_theme = wp_get_theme();
		$this->theme_title = $current_theme->get( 'Name' );
		$this->theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $current_theme->get( 'Name' ) ) );
		$this->page_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_page_slug', $this->theme_name . '-demoimport' );
		$this->parent_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_parent_slug', '' );
	}

	/**
	 * Hooks and filters
	 * @since 1.0.0
	*/
	public function init() {
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'wp_ajax_setup_widgets', array( $this, 'setup_widgets' ) );
	}

	public function enqueue_scripts() {
		wp_enqueue_style( 'demo-import-style', get_template_directory_uri() . '/demo-import/assets/css/demo-import-style.css');
		wp_register_script( 'demo-import-script', get_template_directory_uri() . '/demo-import/assets/js/demo-import-script.js', array( 'jquery' ), time() );
		wp_localize_script(
			'demo-import-script',
			'industrial_technology_whizzie_params',
			array(
				'ajaxurl' 		=> admin_url( 'admin-ajax.php' ),
				'wpnonce' 		=> wp_create_nonce( 'whizzie_nonce' ),
				'verify_text'	=> esc_html( 'verifying', 'industrial-technology' )
			)
		);
		wp_enqueue_script( 'demo-import-script' );
	}

	/**  Make a modal screen for the wizard **/
	public function menu_page() {
		add_menu_page( esc_html( $this->page_title ), esc_html( $this->page_title ), 'manage_options', $this->page_slug, array( $this, 'industrial_technology_guide' ) ,'',40);
	}

	/** Make an interface for the wizard **/
	public function wizard_page() {
		/* If we arrive here, we have the filesystem */ ?>
		<div class="wrap">
			<?php echo '<div class="whizzie-wrap">';
				// The wizard is a list with only one item visible at a time
				$steps = $this->get_steps();
				echo '<ul class="whizzie-nav wizard-icon-nav">';?>
				<?php
					$stepI=1;
					foreach( $steps as $step ) {
						$stepAct=($stepI ==1)? 1 : 0;
						if( isset( $step['icon_text'] ) && $step['icon_text'] ) {
							echo '<li class="commom-cls nav-step-' . esc_attr( $step['id'] ) . '" wizard-steps="step-'.esc_attr( $step['id'] ).'" data-enable="'.$stepAct.'">
							<p>'.esc_attr( $step['icon_text'] ).'</p>
							</li>';
						}
					$stepI++;}
			 	echo '</ul>';
				echo '<ul class="whizzie-menu wizard-menu-page">';
				foreach( $steps as $step ) {
					$class = 'step step-' . esc_attr( $step['id'] );
					echo '<li data-step="' . esc_attr( $step['id'] ) . '" class="' . esc_attr( $class ) . '" >';
						$content = call_user_func( array( $this, $step['view'] ) );
						printf('<div class="wizard-button-wrapper">');
							if( isset( $step['button_text_one'] )) {
								printf(
									'<div class="button-wrap button-wrap-one">
										<a href="#" class="button button-primary do-it" data-callback="install_widgets" data-step="widgets"><p class="demo-type-text">%s</p></a>
									</div>',
									esc_html( $step['button_text_one'] )
								);
							}
						printf('</div>');
					echo '</li>';
				}
				echo '</ul>';
				?>
				<div class="step-loading"><span class="spinner">
					<img src="<?php echo esc_url(get_template_directory_uri().'/demo-import/assets/images/Spinner-Animaion.gif'); ?>">
				</span></div>
			<?php echo '</div>';?>
		</div>
	<?php }

	/**
	 * Set options for the steps
	 * @return Array
	*/
	public function get_steps() {
		$dev_steps = $this->config_steps;
		$steps = array(
			'widgets' => array(
				'id'			=> 'widgets',
				'title'			=> __( 'Customizer', 'industrial-technology' ),
				'icon'			=> 'welcome-widgets-menus',
				'view'			=> 'get_step_widgets',
				'callback'		=> 'install_widgets',
				'button_text_one'	=> __( 'Import Demo', 'industrial-technology' ),
				'can_skip'		=> true,
				'icon_text'      => 'Import Demo'
			),
			'done' => array(
				'id'			=> 'done',
				'title'			=> __( 'All Done', 'industrial-technology' ),
				'icon'			=> 'yes',
				'view'			=> 'get_step_done',
				'callback'		=> '',
				'icon_text'      => 'Done'
			)
		);
		// Iterate through each step and replace with dev config values
		if( $dev_steps ) {
			// Configurable elements - these are the only ones the dev can update from config.php
			$can_config = array( 'title', 'icon', 'button_text', 'can_skip' );
			foreach( $dev_steps as $dev_step ) {
				// We can only proceed if an ID exists and matches one of our IDs
				if( isset( $dev_step['id'] ) ) {
					$id = $dev_step['id'];
					if( isset( $steps[$id] ) ) {
						foreach( $can_config as $element ) {
							if( isset( $dev_step[$element] ) ) {
								$steps[$id][$element] = $dev_step[$element];
							}
						}
					}
				}
			}
		}
		return $steps;
	}

	/**    Print the content for the intro step     **/
		public function get_step_importer() { ?>
		<div class="summary">
			<p>
				<?php esc_html_e('Thank you for choosing this Industrial Technology Theme. Using this quick setup wizard, you will be able to configure your new website and get it running in just a few minutes. Just follow these simple steps mentioned in the wizard and get started with your website.','industrial-technology'); ?>
			</p>
		</div>
	<?php }

	/**   Print the content for the widgets step   **/
	public function get_step_widgets() { ?>
		<div class="summary">
			<p>
				<?php esc_html_e('This theme allows you to import demo content and add widgets. Install them using the button below. You can also update or deactivate them using the Customizer.','industrial-technology'); ?>
			</p>
		</div>
	<?php }

	/** Print the content for the final step **/
	public function get_step_done() { ?>

		<div class="setup-finish">
			<p>
				<?php echo esc_html('Your demo content has been imported successfully. Click the finish button for more information.'); ?>
			</p>
			<div class="finish-buttons">
				<a href="<?php echo esc_url( admin_url( 'themes.php?page=industrial-technology-getstart-page' ) ); ?>" class="wz-btn-customizer" target="_blank"><?php esc_html_e('About Industrial Technology','industrial-technology') ?></a>
				<a href="<?php echo esc_url(admin_url('/customize.php')); ?>" class="wz-btn-customizer" target="_blank"><?php esc_html_e('Customize Your Demo','industrial-technology') ?></a>
				<a href="" class="wz-btn-builder" target="_blank"><?php esc_html_e('Customize Your Demo','industrial-technology'); ?></a>
				<a href="<?php echo esc_url(site_url()); ?>" class="wz-btn-visit-site" target="_blank"><?php esc_html_e('Visit Your Site','industrial-technology'); ?></a>
			</div>
			<div class="finish-buttons">
				<a href="<?php echo esc_url(admin_url()); ?>" class="button button-primary"><?php esc_html_e('Finish','industrial-technology'); ?></a>
			</div>
		</div>

	<?php }


	public function industrial_technology_customizer_nav_menu() {
		// ------- Create Primary Menu --------
		$industrial_technology_themename = 'Industrial Technology'; // Ensure the theme name is set
		$industrial_technology_menuname = $industrial_technology_themename . ' Primary Menu';
		$industrial_technology_menulocation = 'menu-1';
		$industrial_technology_menu_exists = wp_get_nav_menu_object($industrial_technology_menuname);

		if (!$industrial_technology_menu_exists) {
			$industrial_technology_menu_id = wp_create_nav_menu($industrial_technology_menuname);

			// Home
			wp_update_nav_menu_item($industrial_technology_menu_id, 0, array(
				'menu-item-title' => __('Home', 'industrial-technology'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url('/'),
				'menu-item-status' => 'publish'
			));

			// About
			$industrial_technology_page_about = get_page_by_path('about');
			if($industrial_technology_page_about){
				wp_update_nav_menu_item($industrial_technology_menu_id, 0, array(
					'menu-item-title' => __('About', 'industrial-technology'),
					'menu-item-classes' => 'about',
					'menu-item-url' => get_permalink($industrial_technology_page_about),
					'menu-item-status' => 'publish'
				));
			}

			// Services
			$industrial_technology_page_services = get_page_by_path('services');
			if($industrial_technology_page_services){
				wp_update_nav_menu_item($industrial_technology_menu_id, 0, array(
					'menu-item-title' => __('Services', 'industrial-technology'),
					'menu-item-classes' => 'services',
					'menu-item-url' => get_permalink($industrial_technology_page_services),
					'menu-item-status' => 'publish'
				));
			}

			// Blog
			$industrial_technology_page_blog = get_page_by_path('blog');
			if($industrial_technology_page_blog){
				wp_update_nav_menu_item($industrial_technology_menu_id, 0, array(
					'menu-item-title' => __('Blog', 'industrial-technology'),
					'menu-item-classes' => 'blog',
					'menu-item-url' => get_permalink($industrial_technology_page_blog),
					'menu-item-status' => 'publish'
				));
			}

			// Contact Us
			$industrial_technology_page_contact = get_page_by_path('contact');
			if($industrial_technology_page_contact){
				wp_update_nav_menu_item($industrial_technology_menu_id, 0, array(
					'menu-item-title' => __('Contact Us', 'industrial-technology'),
					'menu-item-classes' => 'contact',
					'menu-item-url' => get_permalink($industrial_technology_page_contact),
					'menu-item-status' => 'publish'
				));
			}

			// Assign menu to location if not set
			if (!has_nav_menu($industrial_technology_menulocation)) {
				$industrial_technology_locations = get_theme_mod('nav_menu_locations');
				$industrial_technology_locations[$industrial_technology_menulocation] = $industrial_technology_menu_id; // Use $industrial_technology_menu_id here
				set_theme_mod('nav_menu_locations', $industrial_technology_locations);
			}
		}
	}

	public function industrial_technology_social_menu() {

		// ------- Create Social Menu --------
		$industrial_technology_menuname = $industrial_technology_themename . 'Social Menu';
		$industrial_technology_menulocation = 'social-menu';
		$industrial_technology_menu_exists = wp_get_nav_menu_object( $industrial_technology_menuname );

		if( !$industrial_technology_menu_exists){
			$industrial_technology_menu_id = wp_create_nav_menu($industrial_technology_menuname);

			wp_update_nav_menu_item( $industrial_technology_menu_id, 0, array(
				'menu-item-title'  => __( 'Facebook', 'industrial-technology' ),
				'menu-item-url'    => 'https://www.facebook.com',
				'menu-item-status' => 'publish',
			) );

			wp_update_nav_menu_item( $industrial_technology_menu_id, 0, array(
				'menu-item-title'  => __( 'Pinterest', 'industrial-technology' ),
				'menu-item-url'    => 'https://www.pinterest.com',
				'menu-item-status' => 'publish',
			) );
	
			wp_update_nav_menu_item( $industrial_technology_menu_id, 0, array(
				'menu-item-title'  => __( 'Twitter', 'industrial-technology' ),
				'menu-item-url'    => 'https://www.twitter.com',
				'menu-item-status' => 'publish',
			) );
	
			wp_update_nav_menu_item( $industrial_technology_menu_id, 0, array(
				'menu-item-title'  => __( 'Youtube', 'industrial-technology' ),
				'menu-item-url'    => 'https://www.youtube.com',
				'menu-item-status' => 'publish',
			) );

			wp_update_nav_menu_item( $industrial_technology_menu_id, 0, array(
				'menu-item-title'  => __( 'Instagram', 'industrial-technology' ),
				'menu-item-url'    => 'https://www.instagram.com',
				'menu-item-status' => 'publish',
			) );

			if( !has_nav_menu( $industrial_technology_menulocation ) ){
					$locations = get_theme_mod('nav_menu_locations');
					$locations[$industrial_technology_menulocation] = $industrial_technology_menu_id;
					set_theme_mod( 'nav_menu_locations', $locations );
			}
		}
	}

	/**
	* Imports the Demo Content
	* @since 1.1.0
	*/
	public function setup_widgets() {

		//................................................. MENU PAGES .................................................//
		
		$industrial_technology_home_id='';
		$industrial_technology_home_content = '';

		$industrial_technology_home_title = 'Home';
		$industrial_technology_home = array(
				'post_type' => 'page',
				'post_title' => $industrial_technology_home_title,
				'post_content'  => $industrial_technology_home_content,
				'post_status' => 'publish',
				'post_author' => 1,
				'post_slug' => 'home'
		);
		$industrial_technology_home_id = wp_insert_post($industrial_technology_home);

		//Set the home page template
		add_post_meta( $industrial_technology_home_id, '_wp_page_template', 'revolution-home.php' );

		//Set the static front page
		$industrial_technology_home = get_page_by_title( 'Home' );
		update_option( 'page_on_front', $industrial_technology_home->ID );
		update_option( 'show_on_front', 'page' );


		// Create a posts page and assign the template
		$industrial_technology_blog_title = 'Blog';
		$industrial_technology_blog_check = get_page_by_path('blog');
		if (!$industrial_technology_blog_check) {
			$industrial_technology_blog = array(
				'post_type'    => 'page',
				'post_title'   => $industrial_technology_blog_title,
				'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'blog' // Unique slug for the blog page
			);
			$industrial_technology_blog_id = wp_insert_post($industrial_technology_blog);

			// Set the posts page
			if (!is_wp_error($industrial_technology_blog_id)) {
				update_option('page_for_posts', $industrial_technology_blog_id);
			}
		}

		// Create a Contact Us page and assign the template
		$industrial_technology_contact_title = 'Contact Us';
		$industrial_technology_contact_check = get_page_by_path('contact');
		if (!$industrial_technology_contact_check) {
			$industrial_technology_contact = array(
				'post_type'    => 'page',
				'post_title'   => $industrial_technology_contact_title,
				'post_content'   => '"More About The Free Industrial WordPress Theme"
										The Free Industrial WordPress Theme is expertly designed to cater to the unique needs of industrial businesses, from manufacturing and engineering to logistics and environmental services. Whether you’re offering industrial solutions, machinery, or specialized services, this theme provides a professional platform to showcase your offerings. Its flexible and versatile layout allows you to feature various industrial services, including automation systems, power solutions, industrial equipment rental, and more. The theme’s modern and minimalist design ensures a clean, organized presentation that makes it easy for visitors to navigate and find relevant information quickly. With seamless integration for images, videos, and detailed service descriptions, the theme highlights the quality and range of your services, enhancing user engagement and trust. Whether you’re promoting industrial machinery, safety services, or energy solutions, this theme creates an impactful online presence tailored to your business needs.

										For companies focusing on sustainability, industrial energy solutions, and green technologies, the Free Industrial WordPress Theme offers an ideal platform to showcase your environmental initiatives. The theme is designed to help you highlight your commitment to industrial sustainability, renewable energy, and decarbonization efforts, positioning your business as a leader in eco-friendly solutions. It provides customizable sections to feature services like industrial recycling, waste management, and energy storage, allowing you to effectively communicate your green business practices to a broad audience. With a clean, modern design, the theme ensures your message of sustainability is communicated clearly and professionally. Whether you offer industrial solar solutions, wind energy, or eco-friendly industrial products, this theme provides the perfect space to demonstrate how your business is contributing to a greener future.

										The Free Industrial WordPress Theme also offers valuable benefits for businesses across a wide range of industrial sectors, including manufacturing, construction, and logistics. With built-in features like product galleries, service pages, and team sections, this theme ensures that you can showcase your services and expertise effectively. Whether your business focuses on industrial manufacturing, logistics, automation, or construction, the theme provides a clean and professional design to enhance your online presence. Additionally, the Free Industrial WordPress Theme includes user-friendly customization options, allowing you to effortlessly adjust colors, typography, and layouts to match your brand’s unique identity. With these customizable features, you can create a tailored website that reflects your business’s vision, goals, and professionalism, making it easier to engage with clients and partners in your industry.',
					'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'contact' // Unique slug for the Contact Us page
			);
			wp_insert_post($industrial_technology_contact);
		}

		// Create a About page and assign the template
		$industrial_technology_about_title = 'About';
		$industrial_technology_about_check = get_page_by_path('about');
		if (!$industrial_technology_about_check) {
			$industrial_technology_about = array(
				'post_type'    => 'page',
				'post_title'   => $industrial_technology_about_title,
				'post_content'   => '"More About The Free Industrial WordPress Theme"
										The Free Industrial WordPress Theme is expertly designed to cater to the unique needs of industrial businesses, from manufacturing and engineering to logistics and environmental services. Whether you’re offering industrial solutions, machinery, or specialized services, this theme provides a professional platform to showcase your offerings. Its flexible and versatile layout allows you to feature various industrial services, including automation systems, power solutions, industrial equipment rental, and more. The theme’s modern and minimalist design ensures a clean, organized presentation that makes it easy for visitors to navigate and find relevant information quickly. With seamless integration for images, videos, and detailed service descriptions, the theme highlights the quality and range of your services, enhancing user engagement and trust. Whether you’re promoting industrial machinery, safety services, or energy solutions, this theme creates an impactful online presence tailored to your business needs.

										For companies focusing on sustainability, industrial energy solutions, and green technologies, the Free Industrial WordPress Theme offers an ideal platform to showcase your environmental initiatives. The theme is designed to help you highlight your commitment to industrial sustainability, renewable energy, and decarbonization efforts, positioning your business as a leader in eco-friendly solutions. It provides customizable sections to feature services like industrial recycling, waste management, and energy storage, allowing you to effectively communicate your green business practices to a broad audience. With a clean, modern design, the theme ensures your message of sustainability is communicated clearly and professionally. Whether you offer industrial solar solutions, wind energy, or eco-friendly industrial products, this theme provides the perfect space to demonstrate how your business is contributing to a greener future.

										The Free Industrial WordPress Theme also offers valuable benefits for businesses across a wide range of industrial sectors, including manufacturing, construction, and logistics. With built-in features like product galleries, service pages, and team sections, this theme ensures that you can showcase your services and expertise effectively. Whether your business focuses on industrial manufacturing, logistics, automation, or construction, the theme provides a clean and professional design to enhance your online presence. Additionally, the Free Industrial WordPress Theme includes user-friendly customization options, allowing you to effortlessly adjust colors, typography, and layouts to match your brand’s unique identity. With these customizable features, you can create a tailored website that reflects your business’s vision, goals, and professionalism, making it easier to engage with clients and partners in your industry.',
					'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'about' // Unique slug for the About page
			);
			wp_insert_post($industrial_technology_about);
		}

		// Create a Services page and assign the template
		$industrial_technology_services_title = 'Services';
		$industrial_technology_services_check = get_page_by_path('services');
		if (!$industrial_technology_services_check) {
			$industrial_technology_services = array(
				'post_type'    => 'page',
				'post_title'   => $industrial_technology_services_title,
				'post_content'   => '"More About The Free Industrial WordPress Theme"
										The Free Industrial WordPress Theme is expertly designed to cater to the unique needs of industrial businesses, from manufacturing and engineering to logistics and environmental services. Whether you’re offering industrial solutions, machinery, or specialized services, this theme provides a professional platform to showcase your offerings. Its flexible and versatile layout allows you to feature various industrial services, including automation systems, power solutions, industrial equipment rental, and more. The theme’s modern and minimalist design ensures a clean, organized presentation that makes it easy for visitors to navigate and find relevant information quickly. With seamless integration for images, videos, and detailed service descriptions, the theme highlights the quality and range of your services, enhancing user engagement and trust. Whether you’re promoting industrial machinery, safety services, or energy solutions, this theme creates an impactful online presence tailored to your business needs.

										For companies focusing on sustainability, industrial energy solutions, and green technologies, the Free Industrial WordPress Theme offers an ideal platform to showcase your environmental initiatives. The theme is designed to help you highlight your commitment to industrial sustainability, renewable energy, and decarbonization efforts, positioning your business as a leader in eco-friendly solutions. It provides customizable sections to feature services like industrial recycling, waste management, and energy storage, allowing you to effectively communicate your green business practices to a broad audience. With a clean, modern design, the theme ensures your message of sustainability is communicated clearly and professionally. Whether you offer industrial solar solutions, wind energy, or eco-friendly industrial products, this theme provides the perfect space to demonstrate how your business is contributing to a greener future.

										The Free Industrial WordPress Theme also offers valuable benefits for businesses across a wide range of industrial sectors, including manufacturing, construction, and logistics. With built-in features like product galleries, service pages, and team sections, this theme ensures that you can showcase your services and expertise effectively. Whether your business focuses on industrial manufacturing, logistics, automation, or construction, the theme provides a clean and professional design to enhance your online presence. Additionally, the Free Industrial WordPress Theme includes user-friendly customization options, allowing you to effortlessly adjust colors, typography, and layouts to match your brand’s unique identity. With these customizable features, you can create a tailored website that reflects your business’s vision, goals, and professionalism, making it easier to engage with clients and partners in your industry.',
					'post_status'  => 'publish',
				'post_author'  => 1,
				'post_name'    => 'services' // Unique slug for the Services page
			);
			wp_insert_post($industrial_technology_services);
		}


		// ------------------------------------------ Header -------------------------------------- //

			set_theme_mod('industrial_technology_header_info_phone','+00123-456-7890');
			set_theme_mod('industrial_technology_header_info_time','Mon To Fri 08:00-18:00');
			set_theme_mod('industrial_technology_header_info_email','Industrial12@example.com');

			set_theme_mod('industrial_technology_header_search',1);
			
			set_theme_mod('industrial_technology_facebook_link_option','#');
			set_theme_mod('industrial_technology_twitter_link_option','#');
			set_theme_mod('industrial_technology_pinterest_link_option','#');
			set_theme_mod('industrial_technology_instagram_link_option','#');
			set_theme_mod('industrial_technology_youtube_link_option','#');
			set_theme_mod('industrial_technology_linked_link_option','#');

			set_theme_mod('industrial_technology_enable_slider',1);
			set_theme_mod('industrial_technology_about_sec',1);

		// ------------------------------------------ Slider Section -------------------------------------- //

			for($i=1;$i<=3;$i++){
				set_theme_mod( 'industrial_technology_slider_image'.$i,get_template_directory_uri().'/revolution/assets/images/slider'.$i.'.png' );
				set_theme_mod( 'industrial_technology_slider_top_text'.$i, 'BEST INDUSTIAL COMPANY SINCE 2000 ' );
				set_theme_mod( 'industrial_technology_slider_heading'.$i, 'INDUSTRIAL' );
				set_theme_mod( 'industrial_technology_slider_text'.$i, 'Lorem ipsum is simply dummy text of the printing and typesetting industry.' );
				set_theme_mod( 'industrial_technology_slider_button1_text'.$i, 'DISCOVER MORE' );
				set_theme_mod( 'industrial_technology_slider_button1_link'.$i, '#' );
			}


		// ------------------------------------------ Services Section -------------------------------------- //

			set_theme_mod( 'industrial_technology_about_bg',get_template_directory_uri().'/revolution/assets/images/about.png' );
		
			set_theme_mod('industrial_technology_total_no_happy_customer','8476');
			set_theme_mod('industrial_technology_total_no_yr_experience','30+');
			set_theme_mod('industrial_technology_total_no_project_done','3562');
			set_theme_mod('industrial_technology_total_no_support','1566');
			

  	 	$this->industrial_technology_customizer_nav_menu();
  	 	$this->industrial_technology_social_menu();
	}

	public function industrial_technology_guide() {
		$display_string = '';
		$return = add_query_arg( array()) ;
		$theme = wp_get_theme( 'industrial-technology' );
		?>
		<div class="wrapper-info get-stared-page-wrap">
			<div class="wrapper-info-content">
				<div class="buynow__">
					<h2><?php esc_html_e( 'Welcome to Industrial Technology', 'industrial-technology' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
					<p><?php esc_html_e('The quick setup wizard will assist you in configuring your new website. This wizard will import the demo content.', 'industrial-technology'); ?></p>
				</div>
				<div class="buynow_">
					<a target="_blank" class="buynow_themepage" href="<?php echo esc_url('https://www.revolutionwp.com/products/industry-wordpress-theme'); ?>"><?php echo esc_html__('Go Premium Now', 'industrial-technology'); ?></a>
				</div>
			</div>
			<div class="tab-sec theme-option-tab">
				<div id="demo_offer" class="tabcontent open">
					<?php $this->wizard_page(); ?>
				</div>
			</div>
		</div>
	<?php }
}