<?php
/**
 * Settings for Demo Import
 *
 * @package Whizzie
 * @since 1.0.0
 */

if ( ! defined( 'WHIZZIE_DIR' ) ) {
	define( 'WHIZZIE_DIR', dirname( __FILE__ ) );
}

require trailingslashit( WHIZZIE_DIR ) . 'importer.php';

$current_theme = wp_get_theme();
$theme_title = $current_theme->get( 'Name' );

$industrial_technology_config['page_slug'] 	= 'industrial-technology';
$industrial_technology_config['page_title']	= 'Demo Import';

$industrial_technology_config['steps'] = array(
	'widgets' => array(
		'id'			=> 'widgets',
		'title'			=> __( 'Demo Importer', 'industrial-technology' ),
		'icon'			=> 'welcome-widgets-menus',
		'button_text_one'	=> __( 'Click On The Image To Import Customizer Demo', 'industrial-technology' ),
		'button_text_two'	=> __( 'Click On The Image To Import Gutenberg Block Demo', 'industrial-technology' ),
		'can_skip'		=> true,
	),
	'done' => array(
		'id'			=> 'done',
		'title'			=> __( 'All Done', 'industrial-technology' ),
		'icon'			=> 'yes',
	)
);

if( class_exists( 'ThemeWhizzie' ) ) {
	$ThemeWhizzie = new ThemeWhizzie( $industrial_technology_config );
}