<?php
/**
 * @package Greetings_Plugin
 * @version 1.0.0
 */
/*
Plugin Name: Greetings Plugin
Plugin URI: http://wordpress.org/plugins/greetings-plugin/
Description: This plugin represents the spirit of an era with the famous lyrics from "Hello, Dolly," sung by Louis Armstrong. Activating this plugin will display a random lyric in the top-right corner of your admin screen.
Author: Developer Name
Version: 1.0.0
Author URI: http://developer.example.com/
*/

function get_random_lyric() {
    /** Lyrics from Hello Dolly */
    $songLyrics = "Hello, Dolly
Well, hello, Dolly
It's so nice to have you back where you belong
You're lookin' swell, Dolly
I can tell, Dolly
You're still glowin', you're still crowin'
You're still goin' strong
I feel the room swayin'
While the band's playin'
One of our old favorite songs from way back when
So, take her wrap, fellas
Dolly, never go away again
Hello, Dolly
Well, hello, Dolly
It's so nice to have you back where you belong
You're lookin' swell, Dolly
I can tell, Dolly
You're still glowin', you're still crowin'
You're still goin' strong
I feel the room swayin'
While the band's playin'
One of our old favorite songs from way back when
So, golly, gee, fellas
Have a little faith in me, fellas
Dolly, never go away
Promise, you'll never go away
Dolly'll never go away again";

    // Break lyrics into lines
    $songLyrics = explode("\n", $songLyrics);

    // Pick a random line
    return wptexturize($songLyrics[mt_rand(0, count($songLyrics) - 1)]);
}

// Display the chosen lyric
function display_greeting() {
    $randomLyric = get_random_lyric();
    $languageAttribute = '';
    if ('en_' !== substr(get_user_locale(), 0, 3)) {
        $languageAttribute = ' lang="en"';
    }

    printf(
        '<p id="greeting"><span class="screen-reader-text">%s </span><span dir="ltr"%s>%s</span></p>',
        __('Lyric from Hello Dolly, by Jerry Herman:', 'greetings-plugin'),
        $languageAttribute,
        $randomLyric
    );
}

// Hook the function to the admin_notices action
add_action('admin_notices', 'display_greeting');

// Add CSS for positioning the lyric display