<?php
/**
 * Industrial Technology functions and definitions
 *
 * @package Industrial Technology
 */

if ( ! defined( 'INDUSTRIAL_TECHNOLOGY_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'INDUSTRIAL_TECHNOLOGY_VERSION', '1.0.0' );
}

function industrial_technology_setup() {

	load_theme_textdomain( 'industrial-technology', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'woocommerce' );
	add_theme_support( "align-wide" );
	add_theme_support( "responsive-embeds" );

	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'industrial-technology' ),
			'social-menu' => esc_html__('Social Menu', 'industrial-technology'),
		)
	);

	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	add_theme_support(
		'custom-background',
		apply_filters(
			'industrial_technology_custom_background_args',
			array(
				'default-color' => '#fafafa',
				'default-image' => '',
			)
		)
	);

	add_theme_support( 'post-formats', array(
        'image',
        'video',
        'gallery',
        'audio', 
    ));

	add_theme_support( 'customize-selective-refresh-widgets' );

	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
	
}
add_action( 'after_setup_theme', 'industrial_technology_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function industrial_technology_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'industrial_technology_content_width', 640 );
}
add_action( 'after_setup_theme', 'industrial_technology_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function industrial_technology_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'industrial-technology' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'industrial-technology' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 1', 'industrial-technology' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add widgets here.', 'industrial-technology' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 2', 'industrial-technology' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add widgets here.', 'industrial-technology' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 3', 'industrial-technology' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add widgets here.', 'industrial-technology' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'industrial_technology_widgets_init' );


function industrial_technology_social_menu()
    {
        if (has_nav_menu('social-menu')) :
            wp_nav_menu(array(
                'theme_location' => 'social-menu',
                'container' => 'ul',
                'menu_class' => 'social-menu menu',
                'menu_id'  => 'menu-social',
            ));
        endif;
    }


/**
 * Enqueue scripts and styles.
 */

function industrial_technology_scripts() {
    // Google Fonts
    $query_args = array(
        'family' => 'Poppins:wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900|Raleway:wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
        'display' => 'swap',
    );
    wp_enqueue_style('industrial-technology-google-fonts', add_query_arg($query_args, 'https://fonts.googleapis.com/css'), array(), null);

    // Font Awesome CSS
    wp_enqueue_style('font-awesome-5', get_template_directory_uri() . '/revolution/assets/vendors/font-awesome-5/css/all.min.css', array(), '5.15.3');

    // Owl Carousel CSS
    wp_enqueue_style('owl-carousel-style', get_template_directory_uri() . '/revolution/assets/css/owl.carousel.css', array(), '2.3.4');
    
    // Main stylesheet
    wp_enqueue_style('industrial-technology-style', get_stylesheet_uri(), array(), wp_get_theme()->get('Version'));

    // Add custom inline styles
	require get_parent_theme_file_path('/custom-style.php');
	wp_add_inline_style('industrial-technology-style', $industrial_technology_custom_css);

    // RTL styles if needed
    wp_style_add_data('industrial-technology-style', 'rtl', 'replace');

    // Navigation script
    wp_enqueue_script('industrial-technology-navigation', get_template_directory_uri() . '/js/navigation.js', array(), wp_get_theme()->get('Version'), true);

    // Owl Carousel script
    wp_enqueue_script('owl-carousel-jquery', get_template_directory_uri() . '/revolution/assets/js/owl.carousel.js', array('jquery'), '2.3.4', true);

    // Custom script
    wp_enqueue_script('industrial-technology-custom-js', get_template_directory_uri() . '/revolution/assets/js/custom.js', array('jquery'), wp_get_theme()->get('Version'), true);

    // Comments reply script
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'industrial_technology_scripts');

if (!function_exists('industrial_technology_related_post')) :
    /**
     * Display related posts from same category
     *
     */
    function industrial_technology_related_post($post_id){        
        $categories = get_the_category($post_id);
        if ($categories) {
            $category_ids = array();
            $category = get_category($category_ids);
            $categories = get_the_category($post_id);
            foreach ($categories as $category) {
                $category_ids[] = $category->term_id;
            }
            $count = $category->category_count;
            if ($count > 1) { ?>
                <div class="related-post">
                    
                    <h2 class="post-title"><?php esc_html_e('Related Posts','industrial-technology'); ?></h2>
                    <?php
                    $industrial_technology_cat_post_args = array(
                        'category__in' => $category_ids,
                        'post__not_in' => array($post_id),
                        'post_type' => 'post',
                        'posts_per_page' => 3,
                        'post_status' => 'publish',
						'orderby'           => 'rand',
                        'ignore_sticky_posts' => true
                    );
                    $industrial_technology_featured_query = new WP_Query($industrial_technology_cat_post_args);
                    ?>
                    <div class="rel-post-wrap">
                        <?php
                        if ($industrial_technology_featured_query->have_posts()) :

                        while ($industrial_technology_featured_query->have_posts()) : $industrial_technology_featured_query->the_post();
                            ?>

							<div class="card-item rel-card-item">
								<div class="card-content">
                                    <?php if ( has_post_thumbnail() ) { ?>
                                        <div class="card-media">
                                            <?php industrial_technology_post_thumbnail(); ?>
                                        </div>
                                    <?php } else {
                                        // Fallback default image
                                        $industrial_technology_default_post_thumbnail = get_template_directory_uri() . '/revolution/assets/images/about.png';
                                        echo '<img class="default-post-img" src="' . esc_url( $industrial_technology_default_post_thumbnail ) . '" alt="' . esc_attr( get_the_title() ) . '">';
                                    } ?>
									<div class="entry-title">
										<h3>
											<a href="<?php the_permalink() ?>">
												<?php the_title(); ?>
											</a>
										</h3>
									</div>
									<div class="entry-meta">
                                        <?php
                                        industrial_technology_posted_on();
                                        industrial_technology_posted_by();
                                        ?>
                                    </div>
								</div>
							</div>
                        <?php
                        endwhile;
                        ?>
                <?php
                endif;
                wp_reset_postdata();
                ?>
                </div>
                <?php
            }
        }
    }
endif;
add_action('industrial_technology_related_posts', 'industrial_technology_related_post', 10, 1);

/**
 * Checkbox sanitization callback example.
 *
 * Sanitization callback for 'checkbox' type controls. This callback sanitizes `$checked`
 * as a boolean value, either TRUE or FALSE.
 */
function industrial_technology_sanitize_checkbox($checked)
{
    // Boolean check.
    return ((isset($checked) && true == $checked) ? true : false);
}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/revolution/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/revolution/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/revolution/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/revolution/inc/customizer.php';

/**
 * Breadcrumb File.
 */
require get_template_directory() . '/revolution/inc/breadcrumbs.php';

//////////////////////////////////////////////   Function for Translation Error   //////////////////////////////////////////////////////
function industrial_technology_enqueue_function() {

    /**
    * GET START.
    */
    require get_template_directory() . '/getstarted/industrial_technology_about_page.php';

    /**
    * DEMO IMPORT.
    */
    require get_template_directory() . '/demo-import/industrial_technology_config_file.php';

    
    define('INDUSTRIAL_TECHNOLOGY_FREE_SUPPORT',__('https://wordpress.org/support/theme/industrial-technology/','industrial-technology'));
    define('INDUSTRIAL_TECHNOLOGY_PRO_SUPPORT',__('https://www.revolutionwp.com/pages/community/','industrial-technology'));
    define('INDUSTRIAL_TECHNOLOGY_REVIEW',__('https://wordpress.org/support/theme/industrial-technology/reviews/#new-post','industrial-technology'));
    define('INDUSTRIAL_TECHNOLOGY_BUY_NOW',__('https://www.revolutionwp.com/products/industry-wordpress-theme','industrial-technology'));
    define('INDUSTRIAL_TECHNOLOGY_LIVE_DEMO',__('https://demo.revolutionwp.com/industrial-technology-pro/','industrial-technology'));
    define('INDUSTRIAL_TECHNOLOGY_PRO_DOC',__('https://demo.revolutionwp.com/wpdocs/industrial-technology-pro/','industrial-technology'));
    define('INDUSTRIAL_TECHNOLOGY_LITE_DOC',__('https://demo.revolutionwp.com/wpdocs/industrial-technology-free/','industrial-technology'));
    
}
add_action( 'after_setup_theme', 'industrial_technology_enqueue_function' );

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/revolution/inc/jetpack.php';

}

function industrial_technology_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'industrial_technology_remove_customize_register', 11 );

/************************************************************************************/
// //////////////////////////////////////////////

/**
 * WooCommerce custom filters
 */
add_filter('loop_shop_columns', 'industrial_technology_loop_columns');

if (!function_exists('industrial_technology_loop_columns')) {

	function industrial_technology_loop_columns() {

		$industrial_technology_columns = get_theme_mod( 'industrial_technology_per_columns', 3 );

		return $industrial_technology_columns;
	}
}

/************************************************************************************/

add_filter( 'loop_shop_per_page', 'industrial_technology_per_page', 20 );

function industrial_technology_per_page( $industrial_technology_cols ) {

  	$industrial_technology_cols = get_theme_mod( 'industrial_technology_product_per_page', 9 );

	return $industrial_technology_cols;
}

/************************************************************************************/

add_filter( 'woocommerce_output_related_products_args', 'industrial_technology_products_args' );

function industrial_technology_products_args( $industrial_technology_args ) {

    $industrial_technology_args['posts_per_page'] = get_theme_mod( 'custom_related_products_number', 6 );

    $industrial_technology_args['columns'] = get_theme_mod( 'custom_related_products_number_per_row', 3 );

    return $industrial_technology_args;
}

/************************************************************************************/

/**
 * Custom logo
 */

function industrial_technology_custom_css() {
?>
	<style type="text/css" id="custom-theme-colors" >
        :root {
           
            --industrial_technology_logo_width: <?php echo absint(get_theme_mod('industrial_technology_logo_width')); ?> ;   
        }
        .site-branding img {
            max-width:<?php echo esc_html(get_theme_mod('industrial_technology_logo_width')); ?>px ;    
        }         
	</style>
<?php
}
add_action( 'wp_head', 'industrial_technology_custom_css' );

function industrial_technology_sanitize_choices( $input, $setting ) {
    global $wp_customize; 
    $control = $wp_customize->get_control( $setting->id ); 
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

//Excerpt 
function industrial_technology_excerpt_function($industrial_technology_excerpt_count = 35) {
    $industrial_technology_excerpt = get_the_excerpt();
    $industrial_technology_text_excerpt = wp_strip_all_tags($industrial_technology_excerpt);
    $industrial_technology_excerpt_limit = (int) get_theme_mod('industrial_technology_excerpt_limit', $industrial_technology_excerpt_count);
    $industrial_technology_words = preg_split('/\s+/', $industrial_technology_text_excerpt); 
    $industrial_technology_trimmed_words = array_slice($industrial_technology_words, 0, $industrial_technology_excerpt_limit);
    $industrial_technology_theme_excerpt = implode(' ', $industrial_technology_trimmed_words);

    return $industrial_technology_theme_excerpt;
}

// Add admin notice
function industrial_technology_admin_notice() { 
    global $pagenow;
    $industrial_technology_theme_args      = wp_get_theme();
    $industrial_technology_meta            = get_option( 'industrial_technology_admin_notice' );
    $name            = $industrial_technology_theme_args->__get( 'Name' );
    $industrial_technology_current_screen  = get_current_screen();

    if( !$industrial_technology_meta ){
	    if( is_network_admin() ){
	        return;
	    }

	    if( ! current_user_can( 'manage_options' ) ){
	        return;
	    } 
		
		if($industrial_technology_current_screen->base != 'appearance_page_industrial_technology_guide' ) { ?>
			<div class="notice notice-success">
				<h2><?php esc_html_e('Hey, Thank you for installing Industrial Technology Theme!', 'industrial-technology'); ?><span><a class="info-link" href="<?php echo esc_url( admin_url( 'themes.php?page=industrial-technology-getstart-page' ) ); ?>"><?php esc_html_e('Click Here for more Details', 'industrial-technology'); ?></a></span></h2>
				<p class="dismiss-link"><strong><a href="?industrial_technology_admin_notice=1"><?php esc_html_e( 'Dismiss', 'industrial-technology' ); ?></a></strong></p>
			</div>
			<?php
		}

	}
}

add_action( 'admin_notices', 'industrial_technology_admin_notice' );

if( ! function_exists( 'industrial_technology_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function industrial_technology_update_admin_notice(){
    if ( isset( $_GET['industrial_technology_admin_notice'] ) && $_GET['industrial_technology_admin_notice'] = '1' ) {
        update_option( 'industrial_technology_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'industrial_technology_update_admin_notice' );


add_action('after_switch_theme', 'industrial_technology_setup_options');
function industrial_technology_setup_options () {
    update_option('industrial_technology_admin_notice', FALSE );
}

// changelog
function get_changelog_from_readme() {
    $industrial_technology_file_path = get_template_directory() . '/readme.txt'; // Adjust path if necessary

    if (file_exists($industrial_technology_file_path)) {
        $industrial_technology_content = file_get_contents($industrial_technology_file_path);

        // Extract changelog section
        $industrial_technology_changelog_start = strpos($industrial_technology_content, "== Changelog ==");
        $industrial_technology_changelog = substr($industrial_technology_content, $industrial_technology_changelog_start);

        // Split changelog into versions
        preg_match_all('/\*\s([\d\.]+)\s-\s(.+?)\n((?:\t-\s.+?\n)+)/', $industrial_technology_changelog, $industrial_technology_matches, PREG_SET_ORDER);
        
        return $industrial_technology_matches;
    }
    return [];
}