"use strict";

var _slicedToArray = function() {
  function sliceIterator(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;
    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);
        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }
    return _arr;
  }
  return function(arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if (Symbol.iterator in Object(arr)) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }
  };
}();

(function($) {
  DRTS.DirectoryPro = DRTS.DirectoryPro || {};
  DRTS.DirectoryPro.openingHours = function(periods, open, options) {
    options = options || {};
    var daysOfWeek = options.daysOfWeek || new Map(Object.entries({
      0: "Sunday",
      1: "Monday",
      2: "Tuesday",
      3: "Wednesday",
      4: "Thursday",
      5: "Friday",
      6: "Saturday"
    }));
    var closedStr = options.closedStr || "Closed";
    var use24HourFormat = options.use24HourFormat || false;

    function formatTime(time) {
      var hours = parseInt(time.substring(0, 2));
      var minutes = time.substring(2);

      if (use24HourFormat) {
        return hours.toString().padStart(2, "0") + ":" + minutes;
      } else {
        var period = hours >= 12 ? "pm" : "am";
        hours = hours % 12 || 12;
        return hours + ":" + minutes + " " + period;
      }
    }

    var schedule = {};
    for (var i = 0; i < 7; i++) {
      schedule[i] = [];
    }

    periods.forEach(function(period) {
      var openDay = period.open.day;
      var openTime = formatTime(period.open.time);
      var closeTime = formatTime(period.close.time);
      schedule[openDay].push({
        open: openTime,
        close: closeTime,
        openNum: period.open.time
      });
    });

    for (var day in schedule) {
      schedule[day].sort(function(a, b) {
        return parseInt(a.openNum.replace(/[^0-9]/g, "")) - parseInt(b.openNum.replace(/[^0-9]/g, ""));
      });
    }

    var html = [];
    var value_text_align_class = DRTS.bsPrefix + (DRTS.isRTL ? "text-left" : "text-right");
    html.push('<div class="' + DRTS.bsPrefix + "list-group " + DRTS.bsPrefix + 'list-group-flush drts-entity-fieldlist drts-directory-opening-hours">');

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = daysOfWeek[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var _ref = _step.value;

        var _ref2 = _slicedToArray(_ref, 2);

        var _day = _ref2[0];
        var dayName = _ref2[1];

        var _periods = schedule[parseInt(_day, 10)].map(function(period) {
          return period.open + " - " + period.close;
        });
        html.push('<div class="' + DRTS.bsPrefix + "list-group-item " + DRTS.bsPrefix + 'px-0"><div class="drts-entity-field ' + DRTS.bsPrefix + 'justify-content-between">');
        html.push('<div class="drts-entity-field-label">' + dayName + "</div>");
        html.push('<div class="drts-entity-field-value ' + value_text_align_class + '">' + (_periods.length ? _periods.join(", ") : closedStr) + "</div>");
        html.push("</div></div>");
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    html.push("</div>");
    return html.join("\n");
  };
})(jQuery);