<?php
namespace SabaiApps\Directories\Component\DirectoryPro\FieldRenderer;

use SabaiApps\Directories\Component\Field;
use SabaiApps\Directories\Component\Entity;

class OpeningHoursFieldRenderer extends Field\Renderer\AbstractRenderer
{
    protected function _fieldRendererInfo()
    {
        return [
            'label' => __('Opening Hours', 'directories-pro'),
            'field_types' => ['time', $this->_name],
            'default_settings' => [
                'show_closed' => true,
                'merge_overlaps' => true,
                'closed' => _x('Closed', 'opening hours', 'directories-pro'),
                'appointment_only' => __('Appointment only', 'directories-pro'),
                'all_day' => __('All day', 'directories-pro'),
                '_separator' => ', ',
            ],
        ];
    }

    protected function _fieldRendererSettingsForm(Field\IField $field, array $settings, array $parents = [])
    {
        return array(
            'show_closed' => array(
                '#type' => 'checkbox',
                '#title' => __('Show days without any entry as closed', 'directories-pro'),
                '#default_value' => $settings['show_closed'],
            ),
            'merge_overlaps' => [
                '#type' => 'checkbox',
                '#title' => __('Merge overlapping intervals', 'directories-pro'),
                '#default_value' => !empty($settings['merge_overlaps']),
            ],
            'closed' => array(
                '#type' => 'textfield',
                '#title' => __('Label for closed days', 'directories-pro'),
                '#default_value' => $settings['closed'],
            ),
            'appointment_only' => [
                '#type' => 'textfield',
                '#title' => __('Label for appointment only days', 'directories-pro'),
                '#default_value' => $settings['appointment_only'],
            ],
            'all_day' => [
                '#type' => 'textfield',
                '#title' => __('Label for days open all day', 'directories-pro'),
                '#default_value' => $settings['all_day'],
            ],
        );
    }

    protected function _fieldRendererRenderField(Field\IField $field, array &$settings, Entity\Type\IEntity $entity, array $values, $more = 0)
    {
        if ($field->getFieldType() === 'time') {
            $field_settings = $field->getFieldSettings();
            if (empty($field_settings['enable_day'])) return '';
        }

        return $this->_application->DirectoryPro_OpeningHours($entity, $values, $settings);
    }
}
