<?php
namespace SabaiApps\Directories\Component\DirectoryPro\WordPressBlock;

use SabaiApps\Directories\Component\WordPress\Block\AbstractBlock;
use SabaiApps\Directories\Exception\RuntimeException;
use SabaiApps\Directories\Component\Entity\Model\Bundle;

abstract class AbstractWordPressBlock extends AbstractBlock
{
    abstract protected function _getRenderSettings(Bundle $bundle);

    protected function _getBundleType()
    {
        if (!$bundle_type = $this->wordpressBlockInfo('bundle_type')) {
            throw new RuntimeException('No bundle_type specified in block info.');
        }
        return $bundle_type;
    }

    public function wordpressBlockOnEnqueueEditorAssets($editorScriptHandle)
    {
        /* Temporarily disable loading of view specific JS/CSS as content rendered inside block editor does not seem to execute JS (WP bug?).
        if ($view_mode_name = $this->wordpressBlockInfo('view_mode')) {
            if (!$view_mode = $application->View_Modes_impl($view_mode_name, true)) {
                throw new Exception\UnexpectedValueException(sprintf('Invalid view mode: %s', $view_mode_name));
            }
            $assets = $view_mode->viewModeAssets([]);
            if (!empty($assets['js_files'])) {
                foreach ($assets['js_files'] as $handle => $file) {
                    $url = !isset($file[2]) || $file[2] !== false ? $application->getPlatform()->getAssetsUrl($file[2], !empty($file[4])) . '/js/' . $file[0] : $file[0];
                    wp_enqueue_script($handle, $url, $file[1], Application::VERSION, ['in_footer' => !empty($file[3])]);
                }
            }
            if (!empty($assets['images_loaded_js'])) {
                wp_enqueue_script('imagesloaded');
            }
            if (!empty($assets['css_files'])) {
                foreach ($assets['css_files'] as $handle => $file) {
                    $url = !isset($file[2]) || $file[2] !== false ? $application->getPlatform()->getAssetsUrl($file[2], !empty($file[4])) . '/css/' . $file[0] : $file[0];
                    wp_enqueue_style($handle, $url, $file[1], Application::VERSION, isset($file[3]) ? $file[3] : 'all');
                }
            }
        }
        */
    }

    public function wordpressBlockEditorVars()
    {
        $directories = [];
        foreach ($this->_application->Entity_Bundles_byType($this->_getBundleType(), 'Directory') as $bundle) {
            $directories[] = [
                'value' => $bundle->group,
                'label' => $bundle->getGroupLabel(),
            ];
        }
        return [
            'directories' => $directories,
            'cache_options' => $this->_getCacheOptions(),
        ];
    }

    public function wordpressBlockRender(array $attributes, $content, $isBlockEditorRequest)
    {
        if (empty($attributes['directory'])
            || (!$directory = $this->_application->Directory_Directory($attributes['directory']))
        ) throw new RuntimeException('Invalid directory specified: ' . $attributes['directory']);

        if ($isBlockEditorRequest
            && ($view_mode_name = $this->wordpressBlockInfo('view_mode'))
            && !in_array($view_mode_name, ['list', 'map'])
        ) return;

        $bundle = $this->_application->Entity_Bundle($this->_getBundleType(), 'Directory', $directory->name, true);
        $settings = $this->_getRenderSettings($bundle);
        return $this->_render($bundle->getPath(), $settings);
    }
}