<?php
namespace SabaiApps\Directories\Component\DirectoryPro\WordPressBlock;

use SabaiApps\Directories\Component\Entity\Model\Bundle;

class CategoriesWordPressBlock extends AbstractWordPressBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'title' => _x('Categories', 'WordPress block name', 'directories-pro'),
            'description' => __('Displays a list of categories for your directory.', 'directories-pro'),
            'package' => 'directories-pro',
            'icon' => 'category',
            'bundle_type' => 'directory_category',
            'view_mode' => 'list',
        ];
    }

    protected function _getRenderSettings(Bundle $bundle)
    {
        return [
            'mode' => 'list',
            'settings' => [
                'list_grid' => true,
                'list_no_row' => true,
                'list_grid_gutter_width' => 'md',
                'query' => [
                    'fields' => ['term_parent' => 0],
                ],
                'sort' => [
                    'default' => 'term_title',
                    'options' => array('term_title'),
                ],
                'pagination' => [
                    'no_pagination' => true,
                ],
            ],
        ];
    }
}