<?php
namespace SabaiApps\Directories\Component\DirectoryPro\WordPressBlock;

use SabaiApps\Directories\Component\Entity\Model\Bundle;

class FeaturedListingsWordPressBlock extends AbstractWordPressBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'title' => __('Featured Listings', 'directories-pro'),
            'description' => __('Displays a list of featured listings from your directory.', 'directories-pro'),
            'package' => 'directories-pro',
            'icon' => 'format-gallery',
            'bundle_type' => 'directory__listing',
            'view_mode' => 'slider_photos',
        ];
    }

    protected function _getRenderSettings(Bundle $bundle)
    {
        return [
            'mode' => 'slider_photos',
            'settings' => [
                'photoslider_image_field' => null,
                'photoslider_image_size' => 'thumbnail',
                'photoslider_caption' => true,
                'photoslider_columns' => 10,
                'photoslider_pager' => true,
                'photoslider_auto' => true,
                'photoslider_controls' => true,
                'photoslider_auto_speed' => 3000,
                'photoslider_fade' => false,
                'photoslider_center' => true,
                'photoslider_height' => 135,
                'photoslider_padding' => 5,
                'photoslider_thumbs' => false,
                'photoslider_thumbs_columns' => 5,
                'photoslider_link' => true,
                'photoslider_zoom' => false,
                'query' => [
                    'fields' => ['entity_featured' => 1],
                    'limit' => 12,
                ],
                'sort' => [
                    'default' => 'random',
                    'options' => ['random'],
                ],
                'other' => [
                    'not_found' => [
                        'custom' => true,
                        'html' => '',
                    ],
                ],
            ],
        ];
    }
}