<?php
namespace SabaiApps\Directories\Component\DirectoryPro\WordPressBlock;

use SabaiApps\Directories\Component\Entity\Model\Bundle;

class LocationsWordPressBlock extends AbstractWordPressBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'title' => _x('Locations', 'WordPress block name', 'directories-pro'),
            'description' => __('Displays a list of locations with images from your directory.', 'directories-pro'),
            'package' => 'directories-pro',
            'icon' => 'location',
            'bundle_type' => 'location_location',
            'view_mode' => 'masonry',
        ];
    }

    protected function _getRenderSettings(Bundle $bundle)
    {
        return [
            'mode' => 'masonry',
            'settings' => [
                'query' => [
                    'fields' => [
                        'location_photo' => 1,
                    ],
                    'limit' => 12,
                ],
                'sort' => [
                    'default' => 'random',
                    'options' => ['random'],
                ],
                'pagination' => [
                    'no_pagination' => true,
                ],
                'display' => 'summary-image_overlay',
            ],
        ];
    }
}