<?php
namespace SabaiApps\Directories\Component\DirectoryPro\WordPressBlock;

use SabaiApps\Directories\Component\Entity\Model\Bundle;

class RecentListingsWordPressBlock extends AbstractWordPressBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'title' => __('Recent Listings', 'directories-pro'),
            'description' => __('Displays a list of recently published listings from your directory.', 'directories-pro'),
            'package' => 'directories-pro',
            'icon' => 'excerpt-view',
            'bundle_type' => 'directory__listing',
            'view_mode' => 'slider_carousel',
        ];
    }

    protected function _getRenderSettings(Bundle $bundle)
    {
        return [
            'mode' => 'slider_carousel',
            'settings' => [
                'carousel_columns' => 4,
                'carousel_controls' => 1,
                'carousel_auto' => 1,
                'carousel_auto_speed' => 3000,
                'carousel_pager' => false,
                'carousel_fade' => false,
                'pagination' => [
                    'no_pagination' => 1,
                ],
                'query' => [
                    'limit' => 10,
                ],
                'sort' => [
                    'default' => 'post_published',
                    'options' => ['post_published'],
                ],
            ],
        ];
    }
}