<?php
namespace SabaiApps\Directories\Component\WordPress\Block;

use SabaiApps\Directories\Application;

abstract class AbstractBlock implements IBlock
{
    protected $_application, $_name, $_info;
    protected static $_defaultInfo = [
        'json' => false,
        'package' => 'directories',
        'editor_script' => null,
    ];

    public function __construct(Application $application, $name)
    {
        $this->_application = $application;
        $this->_name = $name;
    }

    public function wordpressBlockInfo($key = null)
    {
        if (!isset($this->_info)) {
            $this->_info = (array)$this->_wordpressBlockInfo() + self::$_defaultInfo;
        }

        return isset($key) ? (isset($this->_info[$key]) ? $this->_info[$key] : null) : $this->_info;
    }

    abstract protected function _wordpressBlockInfo();

    public function wordpressBlockEditorVars()
    {
        return [];
    }

    public function wordpressBlockOnEnqueueEditorAssets($editorScriptHandle) {}

    public function wordpressBlockRender(array $attributes, $content, $isBlockEditorRequest)
    {
        return '';
    }

    public function wordpressBlockPlaceholder(array $attributes, $content)
    {
        $info = $this->wordpressBlockInfo();
        return sprintf(
            '<div class="components-placeholder">
    <div class="components-placeholder__label"><span class="dashicon dashicons dashicons-%3$s"></span>Directories: %4$s</div>
    <div class="drts" style="width:100%%;">
        <div class="%1$salert %1$salert-warning">%2$s</div>
        <p>%5$s</p>
    </div>
</div>',
            DRTS_BS_PREFIX,
            $this->_application->H(__('This block may not be displayed in the backend.', 'directories')),
            $this->_application->H($info['icon']),
            $this->_application->H($info['title']),
            $this->_application->H($info['description'])
        );
    }

    protected function _getCacheOptions()
    {
        $cache_options = [
            ['value' => 0, 'label' => __('No cache', 'directories')],
            ['value' => 3600, 'label'  => sprintf(_n('%d hour', '%d hours', 1, 'directories'), 1)],
            ['value' => 7200, 'label'  => sprintf(_n('%d hour', '%d hours', 2, 'directories'), 2)],
            ['value' => 18000, 'label'  => sprintf(_n('%d hour', '%d hours', 3, 'directories'), 5)],
        ];
        foreach ([1, 2, 3, 5, 7, 10] as $day) {
            $cache_options[] = ['value' => 86400 * $day, 'label' => sprintf(_n('%d day', '%d days', $day, 'directories'), $day)];
        }
        return $cache_options;
    }

    protected function _toSelectControlOptions(array $options)
    {
        $ret = [];
        foreach ($options as $value => $label) {
            $ret[] = ['value' => $value, 'label' => $label];
        }
        return $ret;
    }

    protected function _render($path, array $settings, $cache = null)
    {
        $cache = $this->_application->Filter(
            'wordpress_block_render_cache_lifetime',
            $this->_application->getPlatform()->isDebugEnabled() && !$this->_application->getUser()->isAdministrator() ? false : (isset($cache) ? $cache : false),
            [$this->_name]
        );
        
        $args = $this->_application->Filter('wordpress_block_render_args', [
            'settings' => $settings,
            'cache' => $cache,
        ], [$this->_name]);
        
        return $this->_application->getPlatform()->render(
            $path,
            ['settings' => $args['settings']],
            ['cache' => $args['cache']]
        );
    }
}