<?php
namespace SabaiApps\Directories\Component\WordPress\FormField;

use SabaiApps\Directories\Component\Form;

class UploadFormField extends Form\Field\AbstractUploadField
{
    protected $_defaultRoute = '/_drts/wp/upload';
    
    protected function _getCurrentFiles(array $values)
    {
        $files = [];
        foreach ($values as $value) {
            if (!$src = wp_get_attachment_image_src($value, 'drts_thumbnail_scaled', true)) continue;
                    
            $file_path = get_attached_file($value);
            $ext_and_mime_type = wp_check_filetype(basename($file_path));
            $attr = ['src' => $src[0], 'alt' => ''];
            if ($ext_and_mime_type['ext'] === 'svg') {
                $attr['width'] = 150;
            } else {
                $attr['width'] = $src[1];
                $attr['height'] = $src[2];
            }
            $files[$value] = array(
                'name' => get_the_title($value),
                'icon' => sprintf('<img%s />', $this->_application->Attr($attr)),
                'extension' => $ext_and_mime_type['ext'],
                'url' => wp_get_attachment_url($value),
            );
            if ($filesize = @filesize($file_path)) {
                $files[$value]['size'] = size_format($filesize);
            }
        }
        return $files;
    }
    
    protected function _getDefaultValues(array $defaultValues)
    {
        $ret = [];
        foreach ($defaultValues as $value) {
            $ret[] = $value['attachment_id'];
        }
        return $ret;
    }
    
    protected function _updateFileTitles(array $titles)
    {
        foreach ($titles as $id => $title) {
            $res = wp_update_post(array('ID' => $id, 'post_title' => $title), true);
            if (is_wp_error($res)) {
                $this->_application->logError($res->get_error_message());
            }
        }
    }
    
    protected function _saveFiles(array $files)
    {
        $ret = [];
        foreach ($files as $file_uploaded) {
            if (isset($file_uploaded['saved_file_path'])) {
                $file_uploaded['tmp_name'] = $file_uploaded['saved_file_path']; // WP expects tmp_name
            }
            try {
                $id = $this->_application->getPlatform()->mediaHandleSideload($file_uploaded);
            } catch (\Exception $e) {
                $this->_application->logError($e);
                continue;
            }
            $ret[$id] = $id;
        }
        return $ret;
    }
    
    protected function _onSubmitFail(array $savedFileIds)
    {
        // Delete file data that have been created during submit
        if (!empty($savedFileIds)) {
            foreach ($savedFileIds as $id) {
                wp_delete_attachment($id, true);
            }
        }
    }
}