<?php
namespace SabaiApps\Directories\Helper;

use SabaiApps\Directories\Application;

class DaysHelper
{
    const MONDAY = 1, TUESDAY = 2, WEDNESDAY = 3, THURSDAY = 4, FRIDAY = 5, SATURDAY = 6, SUNDAY = 7;

    protected $_days;
    
    public function help(Application $application, $value = null, $startOfWeek = null)
    {
        if (isset($value)) {
            return isset($this->_days) ? $this->_days[$value] : $this->_day($value);
        }
        
        if (!isset($this->_days)) {
            foreach (range(self::MONDAY, self::SUNDAY) as $value) {
                $this->_days[$value] = $this->_day($value);
            }
            $start_of_week = isset($startOfWeek) && is_int($startOfWeek) ? $startOfWeek : (int)$application->getPlatform()->getStartOfWeek();
            if (isset($this->_days[$start_of_week]) && $start_of_week !== self::MONDAY) {
                $_days = [$start_of_week => $this->_days[$start_of_week]];
                unset($this->_days[$start_of_week]);
                for ($i = $start_of_week + 1; $i <= self::SUNDAY; $i++) {
                    $_days[$i] = $this->_days[$i];
                    unset($this->_days[$i]);
                }
                foreach ($this->_days as $i => $_day) {
                    $_days[$i] = $_day;
                }
                $this->_days = $_days;
            }
        }
        
        return $this->_days;
    }
    
    protected function _day($value)
    {
        switch ($value) {
            case self::MONDAY: 
                return __('Monday', 'directories');
            case self::TUESDAY:
                return __('Tuesday', 'directories');
            case self::WEDNESDAY:
                return __('Wednesday', 'directories');
            case self::THURSDAY:
                return __('Thursday', 'directories');
            case self::FRIDAY:
                return __('Friday', 'directories');
            case self::SATURDAY:
                return __('Saturday', 'directories');
            case self::SUNDAY:
                return __('Sunday', 'directories');
            default:
                return '';
        }
    }
}