<?php
namespace SabaiApps\Directories\Component\Entity\DisplayElement;

use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Display;

class FieldTemplateDisplayElement extends Display\Element\TemplateElement
{
    use WithFieldTrait;

    protected function _displayElementInfo(Entity\Model\Bundle $bundle)
    {
        return array(
            'type' => 'field',
            'label' => _x('Field Template', 'display element name', 'directories'),
            'description' => __('Load and display template file', 'directories'),
            'default_settings' => array(
                'template' => null,
                'label' => 'none',
                'label_custom' => null,
                'label_icon' => null,
                'label_icon_size' => null,
                'label_as_heading' => false,
            ),
            'icon' => 'fab fa-php',
            'inlineable' => true,
            'headingable' => false,
            'designable' => ['margin', 'padding'],
        );
    }
}