<?php

namespace Ademti\WoocommerceMsrp\Admin;

use function dirname;
use function plugins_url;
use function wc_get_product;
use function wc_price;
use function wp_enqueue_style;
use const WOOCOMMERCE_MSRP_VERSION;

class ProductListColumn {

	/**
	 * @return void
	 */
	public function run() {
		add_action( 'admin_init', [ $this, 'admin_init' ] );
	}

	/**
	 * @return void
	 */
	public function admin_init() {
		if ( apply_filters( 'woocommerce_msrp_price_column_hidden', false ) ) {
			return;
		}
		add_filter( 'manage_edit-product_columns', [ $this, 'add_column' ], 10 );
		add_action( 'manage_product_posts_custom_column', [ $this, 'column_data' ], 10, 2 );
	}

	/**
	 * Enqueue our stylesheet.
	 *
	 * @return void
	 */
	public function enqueue_styles() {
		static $done = false;
		if ( $done ) {
			return;
		}
		$plugin_url = dirname( plugins_url( '', __FILE__ ), 2 );
		wp_enqueue_style(
			'woocommerce_msrp_admin',
			$plugin_url . '/css/admin.css',
			[],
			WOOCOMMERCE_MSRP_VERSION
		);
		$done = true;
	}

	/**
	 * Register our new column after the price.
	 *
	 * @param $columns
	 *
	 * @return array
	 */
	public function add_column( $columns ) {
		$this->enqueue_styles();
		$new_columns = [];
		foreach ( $columns as $idx => $label ) {
			$new_columns[ $idx ] = $label;
			if ( $idx === 'price' ) {
				$new_columns['msrp'] = __( 'MSRP Price', 'woocommerce_msrp' );
			}
		}

		return $new_columns;
	}

	/**
	 * Handle outputting the MSRP prices.
	 *
	 * @param $column
	 * @param $post_id
	 *
	 * @return void
	 */
	public function column_data( $column, $post_id ) {
		if ( $column !== 'msrp' ) {
			return;
		}
		$product    = wc_get_product( $post_id );
		$msrp_price = $product->get_meta( '_msrp_price', true );
		if ( $msrp_price === '' ) {
			echo '<span class="na">–</span>';

			return;
		}
		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo wc_price( $msrp_price );
	}
}
