<?php

namespace Ademti\WoocommerceMsrp\Integrations;

use Ademti\WoocommerceMsrp\Dependencies\League\Container\Container;
use const WC_PRODUCT_ADDONS_VERSION;
use const WOOCOMMERCE_GPF_VERSION;

class IntegrationManager {

	// Dependencies.
	private Container $container;

	/**
	 * @param  Container  $container
	 */
	public function __construct( Container $container ) {
		$this->container = $container;
	}

	/**
	 * Run any required integrations.
	 */
	public function run(): void {
		if ( defined( 'WOOCOMMERCE_GPF_VERSION' ) && version_compare( WOOCOMMERCE_GPF_VERSION, '10.0.0' ) ) {
			$this->container->get( 'WoocommerceProductFeeds' )
							->run();
		}
		if ( defined( 'WC_PRODUCT_ADDONS_VERSION' ) && version_compare( WC_PRODUCT_ADDONS_VERSION, '3.0.0', '>=' ) ) {
			$this->container->get( 'ProductAddons' )
							->run();
		}
	}
}
