<?php

namespace Ademti\WoocommerceMsrp;

use Ademti\WoocommerceMsrp\Admin\Admin;
use Ademti\WoocommerceMsrp\Integrations\IntegrationManager;
use function apply_filters;
use function array_keys;
use function array_merge;

class Main {

	// Dependencies.
	private Admin              $admin;
	private Frontend           $frontend;
	private IntegrationManager $integration_manager;
	private RestServiceManager $rest_service_manager;
	private Shortcodes         $shortcodes;

	/**
	 * @param  Admin  $admin
	 * @param  Frontend  $frontend
	 * @param  IntegrationManager  $integration_manager
	 * @param  RestServiceManager  $rest_service_manager
	 * @param  Shortcodes  $shortcodes
	 */
	public function __construct(
		Admin $admin,
		Frontend $frontend,
		IntegrationManager $integration_manager,
		RestServiceManager $rest_service_manager,
		Shortcodes $shortcodes
	) {
		$this->admin                = $admin;
		$this->frontend             = $frontend;
		$this->integration_manager  = $integration_manager;
		$this->shortcodes           = $shortcodes;
		$this->rest_service_manager = $rest_service_manager;
	}

	/**
	 * Runs the plugin.
	 */
	public function run(): void {
		// Bail if WooCommerce is not active.
		$active_plugins = array_merge(
			apply_filters( 'active_plugins', get_option( 'active_plugins', [] ) ),
			array_keys( get_site_option( 'active_sitewide_plugins', [] ) )
		);
		if ( ! in_array( 'woocommerce/woocommerce.php', $active_plugins, true ) ) {
			return;
		}

		$this->integration_manager->run();
		$this->frontend->run();
		$this->shortcodes->run();
		if ( is_admin() ) {
			$this->admin->run();
		}
		$this->rest_service_manager->run();

		add_action( 'init', [ $this, 'init' ] );
	}

	/*
	 * Registers our i18n domains.
	 */
	public function init(): void {
		$domain = 'woocommerce_msrp';
		$locale = apply_filters( 'plugin_locale', get_locale(), $domain );

		load_textdomain( $domain, WP_LANG_DIR . '/woocommerce_msrp/' . $domain . '-' . $locale . '.mo' );
		load_plugin_textdomain( 'woocommerce_msrp', false, 'languages' );
	}
}
