<?php

namespace Ademti\WoocommerceMsrp;

use Ademti\WoocommerceMsrp\Dependencies\League\Container\Container;
use WC_Legacy_REST_API_Plugin;
use function class_exists;
use function get_option;

class RestServiceManager {

	// Dependencies.
	private Container $container;

	/**
	 * @param  Container  $container
	 */
	public function __construct( Container $container ) {
		$this->container = $container;
	}

	/**
	 * Load the relevant REST services.
	 */
	public function run(): void {
		// Always instantiate RestHandler
		$this->container->get( 'RestHandler' )->run();

		// Optionally instantiate the LegacyRestHandler
		if ( 'yes' === get_option( 'woocommerce_api_enabled' ) ||
			class_exists( WC_Legacy_REST_API_Plugin::class ) ) {
			$this->container->get( 'LegacyRestHandler' )->run();
		}
	}
}
