<?php

namespace Ademti\WoocommerceMsrp;

use Exception;
use function ob_get_clean;
use function ob_start;
use function wc_get_product;

class Shortcodes {

	// Dependencies.
	protected Frontend $frontend;

	/**
	 * @param  Frontend  $frontend
	 */
	public function __construct( Frontend $frontend ) {
		$this->frontend = $frontend;
	}

	/**
	 * Run the class.
	 */
	public function run(): void {
		// Register our shortcodes.
		add_shortcode( 'product_msrp_info', [ $this, 'product_msrp_shortcode' ] );
	}

	/**
	 * @param  array  $atts
	 * @param  string  $content
	 *
	 * @return string
	 * @throws Exception
	 */
	public function product_msrp_shortcode( array $atts, string $content ): string {
		global $product;

		$product_id = $atts['product_id'] ?? null;
		if ( ! $product_id ) {
			$shortcode_product = $product;
		} else {
			$shortcode_product = wc_get_product( $product_id );
		}
		if ( ! $shortcode_product ) {
			return $content;
		}

		ob_start();
		$this->frontend->show_msrp( $shortcode_product );
		return ob_get_clean();
	}
}
