<?php
/**
 * Enqueue script and styles for child theme
 */
function woodmart_child_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 10010 );


/* Display the dynamic year in footer */
function year_shortcode() {
  $year = date('Y');
  return $year;
}
add_shortcode('year', 'year_shortcode');

/**
 * @snippet: Remove "Home" in breadcrumb
 */
add_filter( 'woocommerce_breadcrumb_defaults', 'wcc_change_breadcrumb_home_text' );
function wcc_change_breadcrumb_home_text( $defaults ) {
    // Remove the breadcrumb Home text
	$defaults['home'] = ''; // Hide Home
	return $defaults;
}

/**
 * Filter to Change WooCommerce Page Title.
 */
add_filter( 'woocommerce_page_title', 'new_woocommerce_page_title' );
function new_woocommerce_page_title( $page_title ) {
	if ( $page_title == 'Shop' ) {
		return 'Look Cool Babe'; // Add your title here.
	} else {
		echo $page_title;
	}
}

/**
 * Display product attribute archive links 
 */
add_action( 'woocommerce_shop_loop_item_title()', 'bhp_show_attribute_links' );
// if you'd like to show it on archive page, replace "woocommerce_product_meta_end" with "woocommerce_shop_loop_item_title"

function bhp_show_attribute_links() {
	global $post;
	
	$attribute_names = array( '<ATTRIBUTE_NAME>', '<ANOTHER_ATTRIBUTE_NAME>' ); // Add attribute names here and remember to add the pa_ prefix to the attribute name
	
	foreach ( $attribute_names as $attribute_name ) {
		$taxonomy = get_taxonomy( $attribute_name );

		if ( $taxonomy && ! is_wp_error( $taxonomy ) ) {
			$terms = wp_get_post_terms( $post->ID, $attribute_name );
			$terms_array = array();
		
	        if ( ! empty( $terms ) ) {
		        foreach ( $terms as $term ) {
			       $archive_link = get_term_link( $term->slug, $attribute_name );
			       $full_line = '<a href="' . $archive_link . '">'. $term->name . '</a>';
			       array_push( $terms_array, $full_line );
		        }
		        echo $taxonomy->labels->name . ': ' . implode( ', ' . $terms_array );
	        }
    	}
    }
}

/**
 * @snippet: Rename product data tabs
 */
add_filter( 'woocommerce_product_tabs', 'woo_rename_tabs', 98 );
function woo_rename_tabs( $tabs ) {

	$tabs['additional_information']['title'] = __( 'Detail Produk' );	// Rename the additional information tab

	return $tabs;
}


/**
 * @snippet: Customize the Checkout Error Messages
 */
add_action( 'woocommerce_after_checkout_validation', 'bhp_custom_static_notice_on_checkout', 9999, 2);

function bhp_custom_static_notice_on_checkout( $fields, $errors ) {
  // in case any validation errors
  if( !empty( $errors->get_error_codes() ) ) {

    // omit all existing error messages
    foreach( $errors->get_error_codes() as $code ) {
      $errors->remove( $code );
    }

    // display custom single error message
    $errors->add( 'validation', 'Pastikan semua kolom yang diperlukan telah terisi.' );
  }
}

/**
 * @snippet: Plus-minus (±) symbol to weight displayed
 */ 

add_filter( 'woocommerce_format_weight', 'woocommerce_format_weight', 10, 2 );

function woocommerce_format_weight( $weight_string, $weight ) {
    return __( " ± ", "woocommerce" ) . $weight_string;
}


/**
 * @snippet: Replace WooCommerce Cart Shipping Section with a Custom Text
*/

// Remove "Shipping" section from cart page only
add_filter( 'woocommerce_cart_needs_shipping', 'bhp_filter_cart_needs_shipping' );
function bhp_filter_cart_needs_shipping( $needs_shipping ) {
  return is_cart() ? false : $needs_shipping;
}

// Add a custom shipping message row
add_action( 'woocommerce_cart_totals_before_order_total', 'bhp_cart_custom_shipping_message_row' );
function bhp_cart_custom_shipping_message_row() {
  if ( ! WC()->cart->needs_shipping() ) :
    $shipping_message = __("Dihitung pada saat checkout", "woocommerce");
?>
    <tr class="shipping">
      <th><?php _e( 'Shipping', 'woocommerce' ); ?></th>
      <td class="message" data-title="<?php esc_attr_e( 'Shipping', 'woocommerce' ); ?>"><small><?php echo $shipping_message; ?></small></td>
   </tr>
<?php 
  endif;
}


/**
 * @snippet: Ship to One State at WooCommerce Checkout
 */

add_filter( 'woocommerce_countries_shipping_country_states', 'bhp_set_checkout_shipping_state' );
   
function bhp_set_checkout_shipping_state( $states ) {
   $states[ 'ID' ] = array( 'JB' => __( 'Jawa Barat', 'woocommerce' ) );
   return $states;
}

/**
 * @snippet: WC menus and taxonomy archives
 */

add_filter('woocommerce_attribute_show_in_nav_menus', 'wc_reg_for_menus', 1, 2);
function wc_reg_for_menus( $register, $name = '' ) { 
    if ( $name == 'pa_class' ) $register = true;
    return $register;
}



/**
 * Second Category Title at WC Product Category
 */
 
add_action( 'product_cat_add_form_fields', 'bhp_add_category_alt_name' );
add_action( 'product_cat_edit_form_fields', 'bhp_edit_category_alt_name' );
  
function bhp_add_category_alt_name() { 
   echo '<div class="form-field">';
   echo '<label for="ctitle">Alternative title</label>';
   echo '<input type="text" id="ctitle" name="ctitle">';
   echo '</div>';
}
 
function bhp_edit_category_alt_name( $term ) { 
   echo '<tr class="form-field">';
   echo '<th for="ctitle">Alternative title</th>';
   echo '<td><input type="text" id="ctitle" name="ctitle" value="' . get_term_meta( $term->term_id, 'ctitle', true ) . '"></td>';
   echo '</tr>';
}
 
add_action( 'edit_term', 'bhp_save_category_alt_title', 10, 3 );
add_action( 'created_term', 'bhp_save_category_alt_title', 10, 3 );
  
function bhp_save_category_alt_title( $term_id, $tt_id = '', $taxonomy = '' ) {
   if ( 'product_cat' !== $taxonomy ) return;
   if ( isset( $_POST['ctitle'] ) ) {
      update_term_meta( $term_id, 'ctitle', $_POST['ctitle'] );
   } else {
      update_term_meta( $term_id, 'ctitle', '' );
   }
}
 
add_filter( 'woocommerce_page_title', 'bhp_edit_cat_page_title' );
  
function bhp_edit_cat_page_title( $title ) {
   if ( is_product_category() ) {
      $term = get_queried_object();
      $title = get_term_meta( $term->term_id, 'ctitle', true ) ? get_term_meta( $term->term_id, 'ctitle', true ) : $title;
   }
   return $title;
}



/**
 * Shorten product long description with read more button
 */
/* 
function filter_the_content( $content ) {
    // Only for single product pages
    if( ! is_product() ) return $content;

    // Set the limit of words
    $limit = 100;
    
    // Strip p tags if needed
    $content = str_replace( array( '<p>', '</p>' ), '', $content );

    // If the content is longer than the predetermined limit
    if ( str_word_count( $content, 0 ) > $limit ) {
        // Returns an associative array, where the key is the numeric position of the word inside the string and the value is the actual word itself
        $arr = str_word_count( $content, 2 );
        
        // Return all the keys or a subset of the keys of an array
        $pos = array_keys( $arr );
        
        // First part
        $text = '<p>' . substr( $content, 0, $pos[$limit] ) . '<span id="dots">...</span>';
        
        // More part
        $text .= '<span id="more">' . substr( $content, $pos[$limit] ) . '</span></p>';
        
        // Read button
        $text .= '<button id="read-button"></button>';
        
        $content = force_balance_tags( $text ); // needded
    }
    ?>
    <script type="text/javascript">
        jQuery(document).ready( function ($) {
            // Settings
            var read_more_btn_txt = 'Read more';
            var read_less_btn_txt = 'Read less';
            
            // Selectors
            var more = '#more';
            var read_button = '#read-button';
            var dots = '#dots';
            
            // On load
            $( more ).hide();
            $( read_button ).html( read_more_btn_txt );

            // On click
            $( read_button ).on( 'click', function() {
                if ( $( more ).is( ':hidden' ) ) {
                    $( more ).show();
                    $( dots ).hide();
                    $( read_button ).html( read_less_btn_txt );
                } else {
                    $( more ).hide();
                    $( dots ).show();
                    $( read_button ).html( read_more_btn_txt );
                }
            });

        });
    </script>
    <?php
    return $content;
}
add_filter( 'the_content', 'filter_the_content', 10, 1 );

*/

/* Disabled MSRP pricesin the product list */
add_filter( 'woocommerce_msrp_price_column_hidden', '__return_true' );

/* Re-ordering MSRP position hook after the product price */
add_action( 'init', function () {
	global $woocommerce_msrp_frontend;
	remove_action(
		'woocommerce_single_product_summary',
		[ $woocommerce_msrp_frontend, 'show_msrp' ],
		7
	);
	add_action(
		'woocommerce_single_product_summary',
		[ $woocommerce_msrp_frontend, 'show_msrp' ],
		12
	);
} );


