<?php
/**
 * Template Name: Home Page
 */

get_header();
?>

<main id="primary">

    <?php 
    $industrial_technology_main_slider_wrap = absint(get_theme_mod('industrial_technology_enable_slider', 0));
    if($industrial_technology_main_slider_wrap == 1): 
    ?>
        <section id="main-slider-wrap">
            <div class="owl-carousel">
                <?php for ($industrial_technology_main_i=1; $industrial_technology_main_i <= 3; $industrial_technology_main_i++): ?>
                    <?php if ($industrial_technology_slider_image = get_theme_mod('industrial_technology_slider_image'.$industrial_technology_main_i)): ?>
                        <div class="main-slider-inner-box">
                            <img src="<?php echo esc_url($industrial_technology_slider_image); ?>" alt="<?php echo esc_attr( get_theme_mod('industrial_technology_slider_heading'.$industrial_technology_main_i) ); ?>">
                            <div class="main-slider-content-box">
                                <?php if ($industrial_technology_top_text = get_theme_mod('industrial_technology_slider_top_text'.$industrial_technology_main_i)): ?>
                                    <p class="slider-top"><?php echo esc_html($industrial_technology_top_text); ?></p>
                                <?php endif; ?>
                                <?php if ($industrial_technology_heading = get_theme_mod('industrial_technology_slider_heading' . $industrial_technology_main_i)): ?>
                                    <h1><?php echo esc_html($industrial_technology_heading); ?></h1>
                                <?php endif; ?>

                                <?php if ($industrial_technology_text = get_theme_mod('industrial_technology_slider_text'.$industrial_technology_main_i)): ?>
                                    <p class="slider-content"><?php echo esc_html($industrial_technology_text); ?></p>
                                <?php endif; ?>
                                <div class="main-slider-button">
                                    <?php if ( get_theme_mod('industrial_technology_slider_button1_link'.$industrial_technology_main_i) ||  get_theme_mod('industrial_technology_slider_button1_text'.$industrial_technology_main_i )) : ?><a class="slide-btn-1" href="<?php echo esc_url( get_theme_mod('industrial_technology_slider_button1_link'.$industrial_technology_main_i) ); ?>"><?php echo esc_html( get_theme_mod('industrial_technology_slider_button1_text'.$industrial_technology_main_i) ); ?><i class="fas fa-chevron-right"></i></a><?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
        </section>
    <?php endif; ?>

    <?php 
    // Check if the section is enabled
    $industrial_technology_main_expert_wrap = absint(get_theme_mod('industrial_technology_about_sec', 0));
    $industrial_technology_youtube_url = get_theme_mod('industrial_technology_youtube_url', '#');
    if ($industrial_technology_main_expert_wrap == 1): ?>
        <section id="main-about-sec">
            <div class="container">
                <div class="about-image thumbnail position-relative">
                    <?php
                    // Get the background image URL
                    $industrial_technology_about_bg = get_theme_mod('industrial_technology_about_bg');
                    if (!empty($industrial_technology_about_bg)) : ?>
                        <div class="image-wrapper">
                            <img src="<?php echo esc_url($industrial_technology_about_bg); ?>" alt="<?php esc_attr_e('Background Image', 'industrial-technology'); ?>" />
                            <div class="background-overlay"></div>
                        </div>
                    <?php endif; ?>

                    <?php
                    // Get the YouTube URL
                    $industrial_technology_youtube_url = get_theme_mod('industrial_technology_youtube_url','#');
                    if (!empty($industrial_technology_youtube_url)) : ?>
                        <a href="<?php echo esc_url($industrial_technology_youtube_url); ?>" class="youtube-icon-overlay" target="_blank" rel="noopener">
                            <i class="fas fa-play"></i>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="main-about-content-box">
                    <div class="about-box first">
                        <?php if (get_theme_mod('industrial_technology_total_no_happy_customer') != '') { ?>
                            <div class="counter-box">
                                <div class="abt-icon-box">
                                    <i class="fas fa-industry"></i>
                                </div>
                                <div class="abt-content-box">
                                    <div class="abt-up-text"><?php echo esc_html(get_theme_mod('industrial_technology_total_no_happy_customer', '')); ?></div>
                                    <div class="abt-below-text"><?php esc_html_e('Happy Customer', 'industrial-technology'); ?></div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="about-box second">
                        <?php if (get_theme_mod('industrial_technology_total_no_yr_experience') != '') { ?>
                            <div class="counter-box">
                                <div class="abt-icon-box">
                                    <i class="fas fa-chart-bar"></i>
                                </div>
                                <div class="abt-content-box">
                                    <div class="abt-up-text"><?php echo esc_html(get_theme_mod('industrial_technology_total_no_yr_experience', '')); ?></div>
                                    <div class="abt-below-text"><?php esc_html_e('Year Of Experience', 'industrial-technology'); ?></div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="about-box third">
                        <?php if (get_theme_mod('industrial_technology_total_no_project_done') != '') { ?>
                            <div class="counter-box">
                                <div class="abt-icon-box">
                                    <i class="fas fa-mountain"></i>
                                </div>
                                <div class="abt-content-box">
                                    <div class="abt-up-text"><?php echo esc_html(get_theme_mod('industrial_technology_total_no_project_done', '')); ?></div>
                                    <div class="abt-below-text"><?php esc_html_e('Project Done', 'industrial-technology'); ?></div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="about-box fourth">
                        <?php if (get_theme_mod('industrial_technology_total_no_support') != '') { ?>
                            <div class="counter-box">
                                <div class="abt-icon-box">
                                    <i class="fas fa-headset"></i>
                                </div>
                                <div class="abt-content-box">
                                    <div class="abt-up-text"><?php echo esc_html(get_theme_mod('industrial_technology_total_no_support', '')); ?></div>
                                    <div class="abt-below-text"><?php esc_html_e('24/7 Smart Support', 'industrial-technology'); ?></div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
</main>

<?php
get_footer();
?>