<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Industrial Technology
 */

function industrial_technology_body_classes( $industrial_technology_classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$industrial_technology_classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$industrial_technology_classes[] = 'no-sidebar'; 
	}

	return $industrial_technology_classes;
}
add_filter( 'body_class', 'industrial_technology_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function industrial_technology_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'industrial_technology_pingback_header' );