<?php 
if (isset($_GET['import-demo']) && $_GET['import-demo'] == true) {

    // ------- Create Nav Menu --------
$construction_hub_menuname = 'Main Menus';
$construction_hub_bpmenulocation = 'primary-menu';
$construction_hub_menu_exists = wp_get_nav_menu_object($construction_hub_menuname);

if (!$construction_hub_menu_exists) {
    $construction_hub_menu_id = wp_create_nav_menu($construction_hub_menuname);

    // Create Home Page
    $construction_hub_home_title = 'Home';
    $construction_hub_home = array(
        'post_type' => 'page',
        'post_title' => $construction_hub_home_title,
        'post_content' => '',
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'home'
    );
    $construction_hub_home_id = wp_insert_post($construction_hub_home);

    // Assign Home Page Template
    add_post_meta($construction_hub_home_id, '_wp_page_template', 'page-template/front-page.php');

    // Update options to set Home Page as the front page
    update_option('page_on_front', $construction_hub_home_id);
    update_option('show_on_front', 'page');

    // Add Home Page to Menu
    wp_update_nav_menu_item($construction_hub_menu_id, 0, array(
        'menu-item-title' => __('Home', 'construction-hub'),
        'menu-item-classes' => 'home',
        'menu-item-url' => home_url('/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $construction_hub_home_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create About Us Page with Dummy Content
    $construction_hub_about_title = 'About Us';
    $construction_hub_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $construction_hub_about = array(
        'post_type' => 'page',
        'post_title' => $construction_hub_about_title,
        'post_content' => $construction_hub_about_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'about-us'
    );
    $construction_hub_about_id = wp_insert_post($construction_hub_about);

    // Add About Us Page to Menu
    wp_update_nav_menu_item($construction_hub_menu_id, 0, array(
        'menu-item-title' => __('About Us', 'construction-hub'),
        'menu-item-classes' => 'about-us',
        'menu-item-url' => home_url('/about-us/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $construction_hub_about_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Services Page with Dummy Content
    $construction_hub_services_title = 'Services';
    $construction_hub_services_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $construction_hub_services = array(
        'post_type' => 'page',
        'post_title' => $construction_hub_services_title,
        'post_content' => $construction_hub_services_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'services'
    );
    $construction_hub_services_id = wp_insert_post($construction_hub_services);

    // Add Services Page to Menu
    wp_update_nav_menu_item($construction_hub_menu_id, 0, array(
        'menu-item-title' => __('Services', 'construction-hub'),
        'menu-item-classes' => 'services',
        'menu-item-url' => home_url('/services/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $construction_hub_services_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Pages Page with Dummy Content
    $construction_hub_pages_title = 'Pages';
    $construction_hub_pages_content = '<h2>Our Pages</h2>
    <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>';
    $construction_hub_pages = array(
        'post_type' => 'page',
        'post_title' => $construction_hub_pages_title,
        'post_content' => $construction_hub_pages_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'pages'
    );
    $construction_hub_pages_id = wp_insert_post($construction_hub_pages);

    // Add Pages Page to Menu
    wp_update_nav_menu_item($construction_hub_menu_id, 0, array(
        'menu-item-title' => __('Pages', 'construction-hub'),
        'menu-item-classes' => 'pages',
        'menu-item-url' => home_url('/pages/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $construction_hub_pages_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Contact Page with Dummy Content
    $construction_hub_contact_title = 'Contact';
    $construction_hub_contact_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $construction_hub_contact = array(
        'post_type' => 'page',
        'post_title' => $construction_hub_contact_title,
        'post_content' => $construction_hub_contact_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'contact'
    );
    $construction_hub_contact_id = wp_insert_post($construction_hub_contact);

    // Add Contact Page to Menu
    wp_update_nav_menu_item($construction_hub_menu_id, 0, array(
        'menu-item-title' => __('Contact', 'construction-hub'),
        'menu-item-classes' => 'contact',
        'menu-item-url' => home_url('/contact/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $construction_hub_contact_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Set the menu location if it's not already set
    if (!has_nav_menu($construction_hub_bpmenulocation)) {
        $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
        if (empty($locations)) {
            $locations = array();
        }
        $locations[$construction_hub_bpmenulocation] = $construction_hub_menu_id;
        set_theme_mod('nav_menu_locations', $locations);
    }
}

        //---Header--//
        set_theme_mod('construction_hub_call_text', 'CALL US TODAY');
        set_theme_mod('construction_hub_call', '+123-445-6789');
        set_theme_mod('construction_hub_mail_text', 'Email');
        set_theme_mod('construction_hub_mail', 'Construction@gmail.com ');

        // Slider Section
        set_theme_mod('construction_hub_slider_arrows', true);
        set_theme_mod('construction_engineering_slider_text', 'WELCOME TO CONSTRUCTION');

        for ($i = 1; $i <= 4; $i++) {
            $construction_hub_title = 'WE BUILD YOUR DREAMS';
            $construction_hub_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard.';

            // Create post object
            $my_post = array(
                'post_title'    => wp_strip_all_tags($construction_hub_title),
                'post_content'  => $construction_hub_content,
                'post_status'   => 'publish',
                'post_type'     => 'page',
            );

            /// Insert the post into the database
            $post_id = wp_insert_post($my_post);

            if ($post_id) {
                // Set the theme mod for the slider page
                set_theme_mod('construction_hub_slider_page' . $i, $post_id);

                $image_url = get_stylesheet_directory_uri() . '/assets/images/slider-img.png';
                $image_id = media_sideload_image($image_url, $post_id, null, 'id');

                if (!is_wp_error($image_id)) {
                    // Set the downloaded image as the post's featured image
                    set_post_thumbnail($post_id, $image_id);
                }
            }
        }

       // Our Services Section //
    set_theme_mod('construction_engineering_services_heading', 'OUR SERVICES');

    set_theme_mod('construction_engineering_services_section_category', 'postcategory1');

    // Define post category names and post titles
    $construction_engineering_category_names = array('postcategory1');
    $construction_engineering_title_array = array(
        array("Plumbling", "Electricity", "Painting","Cnnstruction", "Civil Work", "Building")
    );

    foreach ($construction_engineering_category_names as $construction_engineering_index => $construction_engineering_category_name) {
        // Create or retrieve the post category term ID
        $construction_engineering_term = term_exists($construction_engineering_category_name, 'category');
        if ($construction_engineering_term === 0 || $construction_engineering_term === null) {
            // If the term does not exist, create it
            $construction_engineering_term = wp_insert_term($construction_engineering_category_name, 'category');
        }
        if (is_wp_error($construction_engineering_term)) {
            error_log('Error creating category: ' . $construction_engineering_term->get_error_message());
            continue; // Skip to the next iteration if category creation fails
        }

        for ($construction_engineering_i = 0; $construction_engineering_i < 6; $construction_engineering_i++) {
            // Create post content
            $construction_engineering_title = $construction_engineering_title_array[$construction_engineering_index][$construction_engineering_i];

            // Create post post object
            $construction_engineering_my_post = array(
                'post_title'    => wp_strip_all_tags($construction_engineering_title),
                'post_status'   => 'publish',
                'post_type'     => 'post', // Post type set to 'post'
            );

            // Insert the post into the database
            $construction_engineering_post_id = wp_insert_post($construction_engineering_my_post);

            if (is_wp_error($construction_engineering_post_id)) {
                error_log('Error creating post: ' . $construction_engineering_post_id->get_error_message());
                continue; // Skip to the next post if creation fails
            }

            // Assign the category to the post
            wp_set_post_categories($construction_engineering_post_id, array((int)$construction_engineering_term['term_id']));

            // Handle the featured image using media_sideload_image
            $construction_engineering_image_url = get_stylesheet_directory_uri() . '/assets/images/post-img' . ($construction_engineering_i + 1) . '.png';
            $construction_engineering_image_id = media_sideload_image($construction_engineering_image_url, $construction_engineering_post_id, null, 'id');

            if (is_wp_error($construction_engineering_image_id)) {
                error_log('Error downloading image: ' . $construction_engineering_image_id->get_error_message());
                continue; // Skip to the next post if image download fails
            }

            // Assign featured image to post
            set_post_thumbnail($construction_engineering_post_id, $construction_engineering_image_id);
        }
    }


    }
?>