"use strict";

(function($) {
  DRTS.Location = DRTS.Location || {};
  DRTS.Location.api = {
    settings: {},
    geocode: function geocode(address, callback, errorHandler) {
      if (typeof address !== "string") {
        address = DRTS.Location.api._stringifyAddress(address, DRTS.Location.api._getGeocodingAddressFormat());
      }
      DRTS.Location.api._geocode(address, callback, errorHandler);
    },
    _geocode: function _geocode(address, callback, errorHandler) {
      console.log("DRTS.Location.api._geocode() is not implemented.");
    },
    reverseGeocode: function reverseGeocode(latlng, callback, errorHandler) {
      var func = DRTS.Location.api.customReverseGeocode || DRTS.Location.api._reverseGeocode;
      func(latlng, callback, errorHandler);
    },
    _reverseGeocode: function _reverseGeocode(latlng, callback, errorHandler) {
      console.log("DRTS.Location.api._reverseGeocode() is not implemented.");
    },
    getTimezone: function getTimezone(latlng, callback, errorHandler) {
      console.log("DRTS.Location.api.getTimezone() is not implemented.");
    },
    autocomplete: function autocomplete(selector, callback) {
      console.log("DRTS.Location.api.autocomplete() is not implemented.");
    },
    getSuggestions: function getSuggestions(query, callback) {
      console.log("DRTS.Location.api.getSuggestions() is not implemented.");
    },
    getPlaceDetails: function getPlaceDetails(placeId, type, callback, errorHandler) {
      console.log("DRTS.Location.api.getPlaceDetails() is not implemented.");
    },
    _getGeocodingAddressFormat: function _getGeocodingAddressFormat() {
      console.log("DRTS.Location.api._getGeocodingAddressFormat() is not implemented.");
    },
    _stringifyAddress: function _stringifyAddress(address, format) {
      for (var key in address) {
        if (key === "address") {
          return address[key];
        }
        if (address.hasOwnProperty(key)) {
          var placeholder = "{" + key + "}";
          format = format.replace(placeholder, address[key]);
        }
      }
      // Remove any remaining placeholders
      format = format.replace(/\{\w+\}/g, "");
      // Remove any spaces before commas
      format = format.replace(/\s*,/g, ",");
      // Remove consecutive commas
      format = format.replace(/,+/g, ",");
      // Remove consecutive spaces
      format = format.replace(/\s+/g, " ");
      return format;
    }
  };
  var DRTS_Location_apiErrors = {
    "Geocoder failed due to: %s": "Geocoder failed due to: %s",
    "Geocoder returned no address components.": "Geocoder returned no address components."
  };
})(jQuery);