"use strict";

(function($) {
  DRTS.Location.api.getPlaceDetails = function(placeId, type, callback, errorHandler) {
    $.get(DRTS_Location_googlemapsApiEndpoint, {
      timestamp: Math.round(new Date().getTime() / 1000).toString(),
      action: "place",
      type: type,
      placeId: placeId
    }, function(results) {
      console.log("GoogleMaps place details results:", results);
      callback(results);
    }).fail(function(xhr, status, error) {
      var err = new Error("Failed fetching place details for " + placeId + ". Status: " + status + " Error: " + error);
      if (errorHandler) {
        errorHandler(err);
      } else {
        throw err;
      }
    });
  };
})(jQuery);