<?php
namespace SabaiApps\Directories\Component\DirectoryPro\WordPressBlock;

use SabaiApps\Directories\Component\WordPress\Block\AbstractBlock;
use SabaiApps\Directories\Exception\RuntimeException;

class FilterFormWordPressBlock extends AbstractBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'title' => _x('Filter Form', 'WordPress block name', 'directories-pro'),
            'description' => __('Displays a filter form.', 'directories-pro'),
            'package' => 'directories-pro',
            'icon' => 'filter',
        ];
    }

    public function wordpressBlockEditorVars()
    {
        $directories = [];
        foreach ($this->_application->getModel('Directory', 'Directory')->fetch() as $directory) {
            if (!$this->_application->Directory_Types_impl($directory->type, true)) continue; // make sure the directory type is active
            
            $directories[] = [
                'value' => $directory->name,
                'label' => $directory->getLabel(),
            ];
        }
        return [
            'directories' => $directories,
            'cache_options' => $this->_getCacheOptions(),
        ];
    }

    public function wordpressBlockRender(array $attributes, $content, $isBlockEditorRequest)
    {
        if (empty($attributes['directory'])
            || (!$directory = $this->_application->Directory_Directory($attributes['directory']))
        ) throw new RuntimeException('Invalid directory specified: ' . $attributes['directory']);

        foreach ($this->_application->Entity_Bundles(null, 'Directory', $directory->name) as $_bundle) {
            if (!empty($_bundle->info['is_primary'])) {
                $bundle = $_bundle;
                break;
            }
        }
        if (empty($bundle)) throw new RuntimeException('Invalid directory specified: ' . $attributes['directory']);

        if ($isBlockEditorRequest) return;

        return '<div class="drts-view-entities-filter-form-placeholder" data-bundle-group="' . $bundle->group . '" data-bundle-type="' . $bundle->type . '"></div>';
    }
}