<?php
namespace SabaiApps\Directories\Component\DirectoryPro\WordPressBlock;

use SabaiApps\Directories\Component\Entity\Model\Bundle;

class RecentReviewsWordPressBlock extends AbstractWordPressBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'title' => __('Recent Reviews', 'directories-pro'),
            'description' => __('Displays a list of recently published reviews from your directory.', 'directories-pro'),
            'package' => 'directories-pro',
            'icon' => 'admin-comments',
            'bundle_type' => 'review_review',
            'view_mode' => 'masonry',
        ];
    }

    protected function _getRenderSettings(Bundle $bundle)
    {
        return [
            'mode' => 'masonry',
            'settings' => [
                'no_js' => true,
                'no_js_grid' => [
                    'masonry_cols' => 'responsive',
                    'masonry_cols_responsive' => ['xs' => 1, 'lg' => 2, 'xl' => 3],
                ],
                'query' => [
                    'limit' => 6,
                ],
                'sort' => [
                    'default' => 'post_published',
                    'options' => ['post_published'],
                ],
            ],
        ];
    }
}