<?php
namespace SabaiApps\Directories\Component\Display\Element;

use SabaiApps\Directories\Component\Entity\Type\IEntity;
use SabaiApps\Directories\Component\Entity\Model\Bundle;
use SabaiApps\Directories\Component\Display\Model\Display;

class HtmlElement extends AbstractElement
{
    protected function _displayElementInfo(Bundle $bundle)
    {
        return [
            'type' => 'content',
            'label' => _x('HTML', 'display element name', 'directories'),
            'description' => __('Renders raw HTML', 'directories'),
            'default_settings' => [
                'html' => '',
            ],
            'icon' => 'fas fa-code',
            'designable' => ['margin', 'padding'],
        ];
    }
    
    public function displayElementSettingsForm(Bundle $bundle, array $settings, Display $display, array $parents = [], $tab = null, $isEdit = false, array $submitValues = [])
    {
        return [
            'html' => [
                '#type' => 'editor',
                '#language' => 'xml',
                '#default_value' => $settings['html'],
                '#required' => true,
                '#description' => $display->type === 'entity' ? $this->_application->System_Util_availableTags($this->_application->Entity_Tokens($bundle, true)) : null,
                '#description_no_escape' => true,
            ],
        ];
    }

    public function displayElementRender(Bundle $bundle, array $element, $var)
    {
        $html = $element['settings']['html'];
        if ($var instanceof IEntity
            && strlen($html)
        ) {
            $html = $this->_application->Entity_Tokens_replace($html, $var, true);
        }
        return $html;
    }

    public function displayElementTitle(Bundle $bundle, array $element)
    {
        return $this->_application->H($element['settings']['html']);
    }

    public function displayElementReadableSettings(Bundle $bundle, array $settings)
    {
        $ret = [
            'html' => [
                'label' => 'HTML',
                'value' => '<code>' . $this->_application->H($settings['html']) . '</code>',
                'is_html' => true,
            ],
        ];
        return ['settings' => ['value' => $ret]];
    }
}