<?php
namespace SabaiApps\Directories\Component\Display\Element;

use SabaiApps\Directories\Component\Display;
use SabaiApps\Directories\Component\Entity\Type\IEntity;
use SabaiApps\Directories\Component\Entity\Model\Bundle;

class JavaScriptElement extends AbstractElement
{
    protected function _displayElementInfo(Bundle $bundle)
    {
        return [
            'type' => 'content',
            'label' => _x('JavaScript', 'display element name', 'directories'),
            'description' => __('Renders raw JavaScript code', 'directories'),
            'default_settings' => [
                'js' => '',
                'no_tags' => false,
            ],
            'designable' => false,
            'icon' => 'far fa-file-code',
            'headingable' => false,
        ];
    }
    
    public function displayElementSettingsForm(Bundle $bundle, array $settings, Display\Model\Display $display, array $parents = [], $tab = null, $isEdit = false, array $submitValues = [])
    {
        $desc = $this->_application->H(__('Enter raw JavaScript code without <script> tags.', 'directories'));
        if ($display->type === 'entity') {
            $desc .= ' ' . $this->_application->System_Util_availableTags($this->_application->Entity_Tokens($bundle, true));
        }
        return [
            'js' => [
                '#type' => 'editor',
                '#language' => 'javascript',
                '#default_value' => $settings['js'],
                '#required' => true,
                '#description' => $desc,
                '#description_no_escape' => true,
            ],
            'no_tags' => [
                '#type' => 'checkbox',
                '#title' => __('Do not add <script> tags', 'directories'),
                '#default_value' => !empty($settings['no_tags']),
                '#horizontal' => true,
            ],
        ];
    }

    public function displayElementRender(Bundle $bundle, array $element, $var)
    {
        $js = $element['settings']['js'];
        if ($var instanceof IEntity
            && strlen($js)
        ) {
            $js = $this->_application->Entity_Tokens_replace($js, $var, true);
        }
        if (!strlen($js)) return;

        if (empty($element['settings']['no_tags'])) {
            $js = '<script type="text/javascript">' . $js . '</script>';
        }
        return ['raw' => $js];
    }

    public function displayElementTitle(Bundle $bundle, array $element)
    {
        return $this->_application->H($element['settings']['js']);
    }

    protected function _displayElementReadableInfo(Bundle $bundle, Display\Model\Element $element)
    {
        $settings = $element->data['settings'];
        $ret = [
            'js' => [
                'label' => 'JavaScript',
                'value' => '<code>' . $this->_application->H($settings['js']) . '</code>',
                'is_html' => true,
            ],
            'no_tags' => [
                'label' => __('Do not add <script> tags', 'directories'),
                'value' => !empty($settings['no_tags']),
                'is_bool' => true,
            ],
        ];
        return ['settings' => ['value' => $ret]];
    }
}