<?php
namespace SabaiApps\Directories\Component\Search\WordPressBlock;

use SabaiApps\Directories\Component\WordPress\Block\AbstractBlock;
use SabaiApps\Directories\Exception\RuntimeException;

class SearchWordPressBlock extends AbstractBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'title' => _x('Search Form', 'WordPress block name', 'directories'),
            'description' => __('Renders a search form for your directory.', 'directories'),
            'package' => 'directories',
            'icon' => 'search',
        ];
    }

    public function wordpressBlockEditorVars()
    {
        $bundles = [];
        foreach ($this->_application->Entity_Bundles(null, 'Directory') as $bundle) {
            if (!empty($bundle->info['search_enable'])) {
                $bundles[] = ['value' => $bundle->name, 'label' => $bundle->getGroupLabel() . ' - ' . $bundle->getLabel()];
            }
        }

        return [
            'bundles' => $bundles,
            'button_colors' => $this->_toSelectControlOptions($this->_getButtonColors()),
            'sizes' => $this->_toSelectControlOptions($this->_getSizes()),
            'responsives' => $this->_toSelectControlOptions($this->_getResponsives()),
        ];
    }

    protected function _getButtonColors()
    {
        return [
            'primary' => 'Primary',
            'secondary' => 'Secondary',
            'success' => 'Success',
            'warning' => 'Warning',
            'danger' => 'Danger',
            'info' => 'Info',
            'dark' => 'Dark',
            'light' => 'Light',
        ];
    }

    protected function _getSizes()
    {
        return [
            '' => __('Normal', 'directories'),
            'lg' => __('Large', 'directories'),
        ];
    }

    protected function _getResponsives()
    {
        return [
            1 => __('Responsive', 'directories'),
            -1 => __('Display inline', 'directories'),
            0 => __('Stacked', 'directories'),
        ];
    }

    public function wordpressBlockRender(array $attributes, $content, $isBlockEditorRequest)
    {
        if (empty($attributes['bundle'])) {
            throw new RuntimeException('No bundle specified.');
        }
        if ((!$bundle = $this->_application->Entity_Bundle($attributes['bundle']))
            || empty($bundle->info['search_enable'])
        ) throw new RuntimeException('Invalid bundle specified: ' . $attributes['bundle']);
        
        $settings = [];
        if (isset($attributes['btnText'])) {
            if ('' === $settings['btn_text'] = trim($attributes['btnText'])) {
                $settings['btn_icon'] = 'fas fa-search';
            }
        } else {
            $settings['btn_text'] = '';
            $settings['btn_icon'] = 'fas fa-search';
        }
        if (!empty($attributes['btnColor'])) {
            $btn_colors = $this->_getButtonColors();
            if (isset($btn_colors[$attributes['btnColor']])) {
                $settings['btn_color'] = $attributes['btnColor'];
            }
        }
        if (isset($attributes['size'])
            && ('' !== $size = trim($attributes['size']))
        ){
            $sizes = $this->_getSizes();
            if (isset($sizes[$size])) {
                $settings['size'] = $size;
            }
        }
        if (isset($attributes['responsive'])
            && is_numeric($attributes['responsive'])
        ){
            $responsive = intval($attributes['responsive']);
            $responsive_options = $this->_getResponsives();
            if (isset($responsive_options[$responsive])) {
                $settings['responsive'] = $responsive;
            }
        }
        if (isset($attributes['style'])
            && ('' !== $style = trim($attributes['style']))
        ){
            $settings['style'] = $style;
        }
        $cache = null;
        if (isset($attributes['cacheLifetime'])
            && ($attributes['cacheLifetime'] = intval($attributes['cacheLifetime']))
        ) {
            $cache = $attributes['cacheLifetime'];
        }
        return $this->_render(
            $bundle->getPath() . '/search', 
            $settings, 
            $cache
        );
    }
}