<?php
namespace SabaiApps\Directories\Component\WordPressContent\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity\Type\IEntity;
use SabaiApps\Directories\Exception\InvalidArgumentException;

class SyncTermsHelper
{
    public function help(Application $application, $entity, $taxonomy = null, array $extraArgs = [])
    {
        if (!$entity instanceof IEntity) {
            if (!$entity = $application->Entity_Entity('post', $entity)) return;
        }
        if ((!$bundle = $application->Entity_Bundle($entity))
            || empty($bundle->info['taxonomies'])
        ) return;

        if (isset($taxonomy)) {
            if (!$bundle_type = array_search($taxonomy, $bundle->info['taxonomies'])) {
                throw new InvalidArgumentException('Invalid taxonomy: ' . $taxonomy);
            }
            $taxonomies = [$bundle_type => $taxonomy];
        } else {
            $taxonomies = $bundle->info['taxonomies'];
        }
        $values = [];
        foreach ($taxonomies as $bundle_type => $taxonomy) {
            $term_ids = wp_get_object_terms($entity->getId(), $taxonomy, ['fields' => 'ids']);
            if (!is_array($term_ids)) continue;

            $values[$bundle_type] = $term_ids;
        }
        $application->Entity_Save($entity, $values, $extraArgs);
    }
}
